/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.query;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.database.QueryUtil;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.index.tree.query.DoubleDistanceSearchCandidate;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialDirectoryEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialPointLeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRStarTree;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRStarTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.query.RStarTreeKNNQuery;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.ComparableMinHeap;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Reference(authors="G. R. Hjaltason, H. Samet", title="Ranking in spatial databases", booktitle="Advances in Spatial Databases - 4th Symposium, SSD'95", url="http://dx.doi.org/10.1007/3-540-60159-7_6")
public class EuclideanRStarTreeKNNQuery<O extends NumberVector>
extends RStarTreeKNNQuery<O> {
    private static final SquaredEuclideanDistanceFunction SQUARED = SquaredEuclideanDistanceFunction.STATIC;

    public EuclideanRStarTreeKNNQuery(AbstractRStarTree<?, ?, ?> abstractRStarTree, Relation<? extends O> relation) {
        super(abstractRStarTree, relation, EuclideanDistanceFunction.STATIC);
    }

    @Override
    public KNNList getKNNForObject(O o, int n) {
        if (n < 1) {
            throw new IllegalArgumentException("At least one neighbor has to be requested!");
        }
        this.tree.statistics.countKNNQuery();
        KNNHeap kNNHeap = DBIDUtil.newHeap(n);
        ComparableMinHeap<DoubleDistanceSearchCandidate> comparableMinHeap = new ComparableMinHeap<DoubleDistanceSearchCandidate>(Math.min(kNNHeap.getK() << 1, 21));
        double d = this.expandNode(o, kNNHeap, comparableMinHeap, Double.MAX_VALUE, this.tree.getRootID());
        while (!comparableMinHeap.isEmpty()) {
            DoubleDistanceSearchCandidate doubleDistanceSearchCandidate = (DoubleDistanceSearchCandidate)comparableMinHeap.poll();
            if (doubleDistanceSearchCandidate.mindist > d) break;
            d = this.expandNode(o, kNNHeap, comparableMinHeap, d, doubleDistanceSearchCandidate.nodeID);
        }
        return QueryUtil.applySqrt(kNNHeap.toKNNList());
    }

    private double expandNode(O o, KNNHeap kNNHeap, ComparableMinHeap<DoubleDistanceSearchCandidate> comparableMinHeap, double d, int n) {
        AbstractRStarTreeNode abstractRStarTreeNode = (AbstractRStarTreeNode)this.tree.getNode(n);
        if (abstractRStarTreeNode.isLeaf()) {
            for (int i = 0; i < abstractRStarTreeNode.getNumEntries(); ++i) {
                SpatialPointLeafEntry spatialPointLeafEntry = (SpatialPointLeafEntry)abstractRStarTreeNode.getEntry(i);
                double d2 = SQUARED.minDist(spatialPointLeafEntry, (SpatialComparable)o);
                this.tree.statistics.countDistanceCalculation();
                if (!(d2 <= d)) continue;
                d = kNNHeap.insert(d2, spatialPointLeafEntry.getDBID());
            }
        } else {
            for (int i = 0; i < abstractRStarTreeNode.getNumEntries(); ++i) {
                SpatialDirectoryEntry spatialDirectoryEntry = (SpatialDirectoryEntry)abstractRStarTreeNode.getEntry(i);
                double d3 = SQUARED.minDist(spatialDirectoryEntry, (SpatialComparable)o);
                this.tree.statistics.countDistanceCalculation();
                if (d3 <= 0.0) {
                    this.expandNode(o, kNNHeap, comparableMinHeap, d, spatialDirectoryEntry.getPageID());
                    continue;
                }
                if (!(d3 <= d)) continue;
                comparableMinHeap.add(new DoubleDistanceSearchCandidate(d3, spatialDirectoryEntry.getPageID()));
            }
        }
        return d;
    }

    @Override
    public List<KNNList> getKNNForBulkDBIDs(ArrayDBIDs arrayDBIDs, int n) {
        DBIDRef dBIDRef;
        if (n < 1) {
            throw new IllegalArgumentException("At least one enumeration has to be requested!");
        }
        HashMap<DBID, KNNHeap> hashMap = new HashMap<DBID, KNNHeap>(arrayDBIDs.size());
        Object object = arrayDBIDs.iter();
        while (object.valid()) {
            dBIDRef = DBIDUtil.deref((DBIDRef)object);
            hashMap.put((DBID)dBIDRef, DBIDUtil.newHeap(n));
            object.advance();
        }
        this.batchNN((AbstractRStarTreeNode)this.tree.getRoot(), hashMap);
        object = new ArrayList();
        dBIDRef = arrayDBIDs.iter();
        while (dBIDRef.valid()) {
            DBID dBID = DBIDUtil.deref(dBIDRef);
            this.tree.statistics.countKNNQuery();
            object.add(QueryUtil.applySqrt(((KNNHeap)hashMap.get(dBID)).toKNNList()));
            dBIDRef.advance();
        }
        return object;
    }
}

