/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.rstar;

import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialDirectoryEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRTreeSettings;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.NonFlatRStarTree;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.rstar.RStarTreeNode;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;

@Title(value="R*-Tree")
@Description(value="Balanced index structure based on bounding rectangles.")
@Reference(authors="N. Beckmann, H.-P. Kriegel, R. Schneider, B. Seeger", title="The R*-tree: an efficient and robust access method for points and rectangles", booktitle="Proceedings of the 1990 ACM SIGMOD International Conference on Management of Data, Atlantic City, NJ, May 23-25, 1990", url="http://dx.doi.org/10.1145/93597.98741")
public abstract class RStarTree
extends NonFlatRStarTree<RStarTreeNode, SpatialEntry, AbstractRTreeSettings> {
    private static final Logging LOG = Logging.getLogger(RStarTree.class);

    public RStarTree(PageFile<RStarTreeNode> pageFile, AbstractRTreeSettings abstractRTreeSettings) {
        super(pageFile, abstractRTreeSettings);
    }

    @Override
    protected SpatialEntry createRootEntry() {
        return new SpatialDirectoryEntry(0, null);
    }

    @Override
    protected SpatialEntry createNewDirectoryEntry(RStarTreeNode rStarTreeNode) {
        return new SpatialDirectoryEntry(rStarTreeNode.getPageID(), rStarTreeNode.computeMBR());
    }

    @Override
    protected RStarTreeNode createNewLeafNode() {
        return new RStarTreeNode(this.leafCapacity, true);
    }

    @Override
    protected RStarTreeNode createNewDirectoryNode() {
        return new RStarTreeNode(this.dirCapacity, false);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }
}

