/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.dependence;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.statistics.dependence.AbstractDependenceMeasure;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arrays.IntegerArrayQuickSort;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arrays.IntegerComparator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import java.util.ArrayList;
import java.util.Arrays;

@Reference(authors="D. Guo", title="Coordinating computational and visual approaches for interactive feature selection and multivariate clustering", booktitle="Information Visualization, 2(4)", url="http://dx.doi.org/10.1057/palgrave.ivs.9500053")
public class MCEDependenceMeasure
extends AbstractDependenceMeasure {
    public static final MCEDependenceMeasure STATIC = new MCEDependenceMeasure();
    public static final int TARGET = 35;

    @Override
    public <A, B> double dependence(NumberArrayAdapter<?, A> numberArrayAdapter, A a, NumberArrayAdapter<?, B> numberArrayAdapter2, B b) {
        int n = MCEDependenceMeasure.size(numberArrayAdapter, a, numberArrayAdapter2, b);
        double d = MathUtil.log2((double)n / 35.0);
        int n2 = Math.max(1, (int)Math.floor(d * 0.5));
        int n3 = 1 << n2;
        double d2 = Math.log(n3);
        ArrayList<int[]> arrayList = this.buildPartitions(numberArrayAdapter, a, n, n2);
        ArrayList<int[]> arrayList2 = this.buildPartitions(numberArrayAdapter2, b, n, n2);
        int[][] nArray = new int[n3][n3];
        this.intersectionMatrix(nArray, arrayList, arrayList2, n3);
        return 1.0 - this.getMCEntropy(nArray, arrayList, arrayList2, n, n3, d2);
    }

    private <A> ArrayList<int[]> buildPartitions(NumberArrayAdapter<?, A> numberArrayAdapter, A a, int n, int n2) {
        int[] nArray = new int[n];
        final double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
            dArray[i] = numberArrayAdapter.getDouble(a, i);
        }
        IntegerArrayQuickSort.sort(nArray, new IntegerComparator(){

            @Override
            public int compare(int n, int n2) {
                return Double.compare(dArray[n], dArray[n2]);
            }
        });
        Arrays.sort(dArray);
        ArrayList<int[]> arrayList = new ArrayList<int[]>(1 << n2);
        this.divide(nArray, dArray, arrayList, 0, dArray.length, n2);
        return arrayList;
    }

    private void divide(int[] nArray, double[] dArray, ArrayList<int[]> arrayList, int n, int n2, int n3) {
        int n4;
        if (n3 == 0) {
            int[] nArray2 = Arrays.copyOfRange(nArray, n, n2);
            Arrays.sort(nArray2);
            arrayList.add(nArray2);
            return;
        }
        int n5 = n2 - n;
        if (n5 == 0) {
            for (int i = 1 << n3; i > 0; --i) {
                arrayList.add(new int[0]);
            }
            return;
        }
        double d = 0.0;
        for (n4 = n; n4 < n2; ++n4) {
            d += dArray[n4];
        }
        n4 = Arrays.binarySearch(dArray, n, n2, d /= (double)n5);
        if (n4 >= 0) {
            int n6 = n + n2 >> 1;
            while (dArray[n4] == d) {
                if (n4 < n6) {
                    ++n4;
                    continue;
                }
                if (n4 > n6) {
                    --n4;
                    continue;
                }
                break;
            }
        } else {
            n4 = -n4 - 1;
        }
        this.divide(nArray, dArray, arrayList, n, n4, n3 - 1);
        this.divide(nArray, dArray, arrayList, n4, n2, n3 - 1);
    }

    private void intersectionMatrix(int[][] nArray, ArrayList<int[]> arrayList, ArrayList<int[]> arrayList2, int n) {
        for (int i = 0; i < n; ++i) {
            int[] nArray2 = arrayList.get(i);
            int[] nArray3 = nArray[i];
            for (int j = 0; j < n; ++j) {
                int[] nArray4 = arrayList2.get(j);
                nArray3[j] = this.intersectionSize(nArray2, nArray4);
            }
        }
    }

    private int intersectionSize(int[] nArray, int[] nArray2) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n < nArray.length && n2 < nArray2.length) {
            int n4 = nArray[n];
            int n5 = nArray2[n];
            if (n4 < n5) {
                ++n;
                continue;
            }
            if (n4 > n5) {
                ++n2;
                continue;
            }
            ++n3;
            ++n;
            ++n2;
        }
        return n3;
    }

    private double getMCEntropy(int[][] nArray, ArrayList<int[]> arrayList, ArrayList<int[]> arrayList2, int n, int n2, double d) {
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            double d2 = arrayList.get(i).length;
            double d3 = arrayList2.get(i).length;
            for (int j = 0; j < n2; ++j) {
                double d4 = (double)nArray[i][j] / d2;
                double d5 = (double)nArray[j][i] / d3;
                if (d4 > 0.0) {
                    int n3 = i;
                    dArray[n3] = dArray[n3] - d4 * Math.log(d4);
                }
                if (!(d5 > 0.0)) continue;
                int n4 = i;
                dArray2[n4] = dArray2[n4] - d5 * Math.log(d5);
            }
        }
        double d6 = 0.0;
        double d7 = 0.0;
        for (int i = 0; i < n2; ++i) {
            d6 += dArray[i] * (double)arrayList.get(i).length;
            d7 += dArray2[i] * (double)arrayList2.get(i).length;
        }
        double d8 = d6 > d7 ? d6 : d7;
        return d8 / ((double)n * d);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected MCEDependenceMeasure makeInstance() {
            return STATIC;
        }
    }
}

