/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.dependence;

import de.lmu.ifi.dbs.elki.math.statistics.dependence.AbstractDependenceMeasure;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public class SpearmanCorrelationDependenceMeasure
extends AbstractDependenceMeasure {
    public static final SpearmanCorrelationDependenceMeasure STATIC = new SpearmanCorrelationDependenceMeasure();

    protected SpearmanCorrelationDependenceMeasure() {
    }

    @Override
    public <A, B> double dependence(NumberArrayAdapter<?, A> numberArrayAdapter, A a, NumberArrayAdapter<?, B> numberArrayAdapter2, B b) {
        int n = SpearmanCorrelationDependenceMeasure.size(numberArrayAdapter, a, numberArrayAdapter2, b);
        double[] dArray = SpearmanCorrelationDependenceMeasure.computeNormalizedRanks(numberArrayAdapter, a, n);
        double[] dArray2 = SpearmanCorrelationDependenceMeasure.computeNormalizedRanks(numberArrayAdapter2, b, n);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d4 = dArray[i] - 0.5;
            double d5 = dArray2[i] - 0.5;
            d += d4 * d4;
            d2 += d5 * d5;
            d3 += d4 * d5;
        }
        return d3 / Math.sqrt(d * d2);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected SpearmanCorrelationDependenceMeasure makeInstance() {
            return STATIC;
        }
    }
}

