/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.NormalDistribution;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import java.util.Random;

@Alias(value={"de.lmu.ifi.dbs.elki.data.synthetic.bymodel.distribution.GammaDistribution"})
public class GammaDistribution
extends AbstractDistribution {
    public static final double EULERS_CONST = 0.5772156649015329;
    static final double[] LANCZOS = new double[]{0.9999999999999971, 57.15623566586292, -59.59796035547549, 14.136097974741746, -0.4919138160976202, 3.399464998481189E-5, 4.652362892704858E-5, -9.837447530487956E-5, 1.580887032249125E-4, -2.1026444172410488E-4, 2.1743961811521265E-4, -1.643181065367639E-4, 8.441822398385275E-5, -2.6190838401581408E-5, 3.6899182659531625E-6};
    static final double NUM_PRECISION = 1.0E-15;
    static final int MAX_ITERATIONS = 1000;
    private final double k;
    private final double theta;

    public GammaDistribution(double d, double d2, Random random) {
        super(random);
        if (!(d > 0.0) || !(d2 > 0.0)) {
            throw new IllegalArgumentException("Invalid parameters for Gamma distribution: " + d + " " + d2);
        }
        this.k = d;
        this.theta = d2;
    }

    public GammaDistribution(double d, double d2, RandomFactory randomFactory) {
        super(randomFactory);
        if (!(d > 0.0) || !(d2 > 0.0)) {
            throw new IllegalArgumentException("Invalid parameters for Gamma distribution: " + d + " " + d2);
        }
        this.k = d;
        this.theta = d2;
    }

    public GammaDistribution(double d, double d2) {
        this(d, d2, (Random)null);
    }

    @Override
    public double pdf(double d) {
        return GammaDistribution.pdf(d, this.k, this.theta);
    }

    @Override
    public double cdf(double d) {
        return GammaDistribution.cdf(d, this.k, this.theta);
    }

    @Override
    public double quantile(double d) {
        return GammaDistribution.quantile(d, this.k, this.theta);
    }

    @Override
    public double nextRandom() {
        return GammaDistribution.nextRandom(this.k, this.theta, this.random);
    }

    @Override
    public String toString() {
        return "GammaDistribution(k=" + this.k + ", theta=" + this.theta + ")";
    }

    public double getK() {
        return this.k;
    }

    public double getTheta() {
        return this.theta;
    }

    public static double cdf(double d, double d2, double d3) {
        if (d < 0.0) {
            return 0.0;
        }
        return GammaDistribution.regularizedGammaP(d2, d * d3);
    }

    public static double logcdf(double d, double d2, double d3) {
        if (d < 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        return GammaDistribution.logregularizedGammaP(d2, d * d3);
    }

    public static double pdf(double d, double d2, double d3) {
        if (d < 0.0) {
            return 0.0;
        }
        if (d == 0.0) {
            if (d2 == 1.0) {
                return d3;
            }
            return 0.0;
        }
        if (d2 == 1.0) {
            return Math.exp(-d * d3) * d3;
        }
        return Math.exp((d2 - 1.0) * Math.log(d * d3) - d * d3 - GammaDistribution.logGamma(d2)) * d3;
    }

    public static double logpdf(double d, double d2, double d3) {
        if (d < 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (d == 0.0) {
            if (d2 == 1.0) {
                return Math.log(d3);
            }
            return Double.NEGATIVE_INFINITY;
        }
        if (d2 == 1.0) {
            return Math.log(d3) - d * d3;
        }
        return Math.log(d3) + (d2 - 1.0) * Math.log(d * d3) - d * d3 - GammaDistribution.logGamma(d2);
    }

    public static double logGamma(double d) {
        if (Double.isNaN(d) || d <= 0.0) {
            return Double.NaN;
        }
        double d2 = 4.7421875;
        double d3 = d + d2 + 0.5;
        d3 = (d + 0.5) * Math.log(d3) - d3;
        double d4 = LANCZOS[0];
        for (int i = LANCZOS.length - 1; i > 0; --i) {
            d4 += LANCZOS[i] / (d + (double)i);
        }
        return d3 + Math.log(MathUtil.SQRTTWOPI * d4 / d);
    }

    public static double gamma(double d) {
        return Math.exp(GammaDistribution.logGamma(d));
    }

    public static double regularizedGammaP(double d, double d2) {
        double d3;
        if (Double.isInfinite(d) || Double.isInfinite(d2) || !(d > 0.0) || !(d2 >= 0.0)) {
            return Double.NaN;
        }
        if (d2 == 0.0) {
            return 0.0;
        }
        if (d2 >= d + 1.0) {
            return 1.0 - GammaDistribution.regularizedGammaQ(d, d2);
        }
        double d4 = d3 = 1.0 / d;
        for (int i = 1; i < 1000; ++i) {
            if ((d4 += (d3 = d2 / (d + (double)i) * d3)) == Double.POSITIVE_INFINITY) {
                return 1.0;
            }
            if (Math.abs(d3 / d4) < 1.0E-15) break;
        }
        return Math.exp(-d2 + d * Math.log(d2) - GammaDistribution.logGamma(d)) * d4;
    }

    public static double logregularizedGammaP(double d, double d2) {
        double d3;
        if (Double.isNaN(d) || Double.isNaN(d2) || d <= 0.0 || d2 < 0.0) {
            return Double.NaN;
        }
        if (d2 == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (d2 >= d + 1.0) {
            return Math.log(1.0 - GammaDistribution.regularizedGammaQ(d, d2));
        }
        double d4 = d3 = 1.0 / d;
        for (int i = 1; i < Integer.MAX_VALUE && !(Math.abs((d3 *= d2 / (d + (double)i)) / (d4 += d3)) < 1.0E-15) && !(d4 >= Double.POSITIVE_INFINITY); ++i) {
        }
        if (Double.isInfinite(d4)) {
            return 0.0;
        }
        return -d2 + d * Math.log(d2) - GammaDistribution.logGamma(d) + Math.log(d4);
    }

    public static double regularizedGammaQ(double d, double d2) {
        double d3;
        if (Double.isNaN(d) || Double.isNaN(d2) || d <= 0.0 || d2 < 0.0) {
            return Double.NaN;
        }
        if (d2 == 0.0) {
            return 1.0;
        }
        if (d2 < d + 1.0) {
            return 1.0 - GammaDistribution.regularizedGammaP(d, d2);
        }
        double d4 = d2 + 1.0 - d;
        double d5 = Double.POSITIVE_INFINITY;
        double d6 = d3 = 1.0 / d4;
        for (int i = 1; i < 1000; ++i) {
            double d7 = (double)i * (d - (double)i);
            if (Math.abs(d3 = d7 * d3 + (d4 += 2.0)) < 4.940656458412465E-309) {
                d3 = 4.940656458412465E-309;
            }
            if (Math.abs(d5 = d4 + d7 / d5) < 4.940656458412465E-309) {
                d5 = 4.940656458412465E-309;
            }
            d3 = 1.0 / d3;
            double d8 = d3 * d5;
            d6 *= d8;
            if (Math.abs(d8 - 1.0) <= 1.0E-15) break;
        }
        return d6 * Math.exp(-d2 + d * Math.log(d2) - GammaDistribution.logGamma(d));
    }

    public static double nextRandom(double d, double d2, Random random) {
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        double d11;
        double d12;
        if (d < 1.0) {
            double d13;
            double d14 = 1.0 + 0.36788794412 * d;
            while (true) {
                double d15;
                if ((d15 = d14 * random.nextDouble()) <= 1.0) {
                    d13 = Math.exp(Math.log(d15) / d);
                    if (!(Math.log(random.nextDouble()) <= -d13)) continue;
                    return d13 / d2;
                }
                d13 = -Math.log((d14 - d15) / d);
                if (Math.log(random.nextDouble()) <= (d - 1.0) * Math.log(d13)) break;
            }
            return d13 / d2;
        }
        if (d != -1.0) {
            d12 = d - 0.5;
            d11 = Math.sqrt(d12);
            d10 = 5.656854249 - 12.0 * d11;
        } else {
            d12 = 0.0;
            d11 = 0.0;
            d10 = 0.0;
        }
        while ((d9 = (d8 = 2.0 * random.nextDouble() - 1.0) * d8 + (d7 = 2.0 * random.nextDouble() - 1.0) * d7) > 1.0) {
        }
        double d16 = d8;
        double d17 = d9;
        double d18 = d16 * Math.sqrt(-2.0 * Math.log(d17) / d17);
        double d19 = d11 + 0.5 * d18;
        double d20 = d19 * d19;
        if (d18 >= 0.0) {
            return d20 / d2;
        }
        double d21 = random.nextDouble();
        if (d10 * d21 <= d18 * d18 * d18) {
            return d20 / d2;
        }
        if (d != -1.0) {
            d6 = 1.0 / d;
            d5 = ((((((((1.71032E-4 * d6 + -4.701849E-4) * d6 + 6.053049E-4) * d6 + 3.340332E-4) * d6 + -3.349403E-4) * d6 + 0.0015746717) * d6 + 0.0079849875) * d6 + 0.0208333723) * d6 + 0.0416666664) * d6;
            if (d > 3.686) {
                if (d > 13.022) {
                    d8 = 1.77;
                    d9 = 0.75;
                    d7 = 0.1515 / d11;
                } else {
                    d8 = 1.654 + 0.0076 * d12;
                    d9 = 1.68 / d11 + 0.275;
                    d7 = 0.062 / d11 + 0.024;
                }
            } else {
                d8 = 0.463 + d11 - 0.178 * d12;
                d9 = 1.235;
                d7 = 0.195 / d11 - 0.079 + 0.016 * d11;
            }
        } else {
            d8 = 0.0;
            d7 = 0.0;
            d9 = 0.0;
            d5 = 0.0;
        }
        if (d19 > 0.0) {
            d6 = d18 / (d11 + d11);
            d4 = Math.abs(d6) > 0.25 ? d5 - d11 * d18 + 0.25 * d18 * d18 + (d12 + d12) * Math.log(1.0 + d6) : d5 + 0.5 * d18 * d18 * ((((((((0.104089866 * d6 + -0.112750886) * d6 + 0.11036831) * d6 + -0.124385581) * d6 + 0.142873973) * d6 + -0.166677482) * d6 + 0.199999867) * d6 + -0.249999949) * d6 + 0.333333333) * d6;
            if (Math.log(1.0 - d21) <= d4) {
                return d20 / d2;
            }
        }
        do {
            d18 = -Math.log(random.nextDouble());
            d19 = random.nextDouble();
        } while ((d21 = d8 + d18 * d9 * (d20 = (d19 = d19 + d19 - 1.0) > 0.0 ? 1.0 : -1.0)) <= -0.71874483771719 || (d4 = Math.abs(d6 = d21 / (d11 + d11)) > 0.25 ? d5 - d11 * d21 + 0.25 * d21 * d21 + (d12 + d12) * Math.log(1.0 + d6) : d5 + 0.5 * d21 * d21 * ((((((((0.104089866 * d6 + -0.112750886) * d6 + 0.11036831) * d6 + -0.124385581) * d6 + 0.142873973) * d6 + -0.166677482) * d6 + 0.199999867) * d6 + -0.249999949) * d6 + 0.333333333) * d6) <= 0.0 || !(d7 * d19 * d20 <= (d3 = d4 > 0.5 ? Math.exp(d4) - 1.0 : ((((((2.47453E-4 * d4 + 0.001353826) * d4 + 0.008345522) * d4 + 0.041664508) * d4 + 0.166666848) * d4 + 0.499999994) * d4 + 1.0) * d4) * Math.exp(d18 - 0.5 * d21 * d21)));
        double d22 = d11 + 0.5 * d21;
        return d22 * d22 / d2;
    }

    @Reference(title="Algorithm AS 91: The percentage points of the $\\chi^2$ distribution", authors="D.J. Best, D. E. Roberts", booktitle="Journal of the Royal Statistical Society. Series C (Applied Statistics)")
    protected static double chisquaredProbitApproximation(double d, double d2, double d3) {
        double d4;
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            return Double.NaN;
        }
        if (d <= 0.0) {
            return 0.0;
        }
        if (d >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (d2 <= 0.0) {
            return Double.NaN;
        }
        double d5 = 0.5 * d2;
        double d6 = Math.log(d);
        if (d2 < -1.24 * d6) {
            return Math.pow(d * d5 * Math.exp(d3 + d5 * MathUtil.LOG2), 1.0 / d5);
        }
        if (d2 > 0.32) {
            double d7;
            double d8 = NormalDistribution.quantile(d, 0.0, 1.0);
            double d9 = d8 * Math.sqrt(d7 = 2.0 / (9.0 * d2)) + 1.0 - d7;
            double d10 = d2 * d9 * d9 * d9;
            if (d10 > 2.2 * d2 + 6.0) {
                d10 = -2.0 * (Math.log1p(-d) - (d5 - 1.0) * Math.log(0.5 * d10) + d3);
            }
            return d10;
        }
        double d11 = Math.log1p(-d) + d3 + (d5 - 1.0) * MathUtil.LOG2;
        double d12 = 0.4;
        do {
            double d13 = 1.0 + d12 * (4.67 + d12);
            double d14 = d12 * (6.73 + d12 * (6.66 + d12));
            double d15 = -0.5 + (4.67 + 2.0 * d12) / d13 - (6.73 + d12 * (13.32 + 3.0 * d12)) / d14;
            d4 = (1.0 - Math.exp(d11 + 0.5 * d12) * d14 / d13) / d15;
            d12 -= d4;
        } while (!(Math.abs(d4) > 0.01 * Math.abs(d12)));
        return d12;
    }

    @Reference(title="Algorithm AS 91: The percentage points of the $\\chi^2$ distribution", authors="D.J. Best, D. E. Roberts", booktitle="Journal of the Royal Statistical Society. Series C (Applied Statistics)")
    public static double quantile(double d, double d2, double d3) {
        double d4;
        double d5;
        int n;
        block17: {
            double d6;
            if (Double.isNaN(d) || Double.isNaN(d2) || Double.isNaN(d3)) {
                return Double.NaN;
            }
            if (d <= 0.0) {
                return 0.0;
            }
            if (d >= 1.0) {
                return Double.POSITIVE_INFINITY;
            }
            if (d2 < 0.0 || d3 <= 0.0) {
                return Double.NaN;
            }
            if (d2 == 0.0) {
                return 0.0;
            }
            n = 1;
            if (d2 < 1.0E-10) {
                n = 7;
            }
            if (Double.isInfinite(d5 = GammaDistribution.chisquaredProbitApproximation(d, 2.0 * d2, d6 = GammaDistribution.logGamma(d2)))) {
                n = 0;
            } else if (d5 < 5.0E-7) {
                n = 20;
            } else if (d > 0.99999999999999 || d < 1.0E-100) {
                n = 20;
            } else {
                d4 = d2 - 1.0;
                double d7 = d5;
                for (int i = 1; i <= 1000; ++i) {
                    double d8;
                    double d9;
                    double d10;
                    double d11;
                    double d12;
                    double d13;
                    double d14;
                    double d15;
                    double d16;
                    double d17 = d5;
                    double d18 = 0.5 * d5;
                    double d19 = d - GammaDistribution.regularizedGammaP(d2, d18);
                    if (Double.isInfinite(d19) || d5 <= 0.0) {
                        d5 = d7;
                        n = 27;
                    } else if (!(Math.abs(d17 - (d5 += (d16 = d19 * Math.exp(d2 * MathUtil.LOG2 + d6 + d18 - d4 * Math.log(d5))) * (1.0 + 0.5 * d16 * (d15 = (210.0 + (d14 = 0.5 * d16 - (d13 = d16 / d5) * d4) * (140.0 + d14 * (105.0 + d14 * (84.0 + d14 * (70.0 + 60.0 * d14))))) / 420.0) - d13 * d4 * (d15 - d13 * ((d12 = (420.0 + d14 * (735.0 + d14 * (966.0 + d14 * (1141.0 + 1278.0 * d14)))) / 2520.0) - d13 * ((d11 = (210.0 + d14 * (462.0 + d14 * (707.0 + 932.0 * d14))) / 2520.0) - d13 * ((d10 = (252.0 + d14 * (672.0 + 1182.0 * d14) + d4 * (294.0 + d14 * (889.0 + 1740.0 * d14))) / 5040.0) - d13 * ((d9 = (84.0 + 2264.0 * d14 + d4 * (1175.0 + 606.0 * d14)) / 2520.0) - d13 * (d8 = (120.0 + d4 * (346.0 + 127.0 * d4)) / 5040.0))))))))) < 5.0E-7 * d5)) {
                        if (!(Math.abs(d17 - d5) > 0.1 * Math.abs(d5))) continue;
                        d5 = (d5 < d17 ? 0.9 : 1.1) * d17;
                        continue;
                    }
                    break block17;
                }
                LoggingUtil.warning("No convergence in AS 91 Gamma probit.");
            }
        }
        d4 = 0.5 * d5 / d3;
        if (n > 0) {
            d4 = GammaDistribution.gammaQuantileNewtonRefinement(Math.log(d), d2, d3, n, d4);
        }
        return d4;
    }

    protected static double gammaQuantileNewtonRefinement(double d, double d2, double d3, int n, double d4) {
        double d5;
        double d6;
        double d7;
        if (d4 <= 0.0) {
            d4 = Double.MIN_NORMAL;
        }
        double d8 = GammaDistribution.logcdf(d4, d2, d3);
        if (d4 == Double.MIN_NORMAL && d8 > d * 1.0000001) {
            return 0.0;
        }
        if (d8 == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        for (int i = 0; !(i >= n || Math.abs(d7 = d8 - d) < Math.abs(1.0E-15 * d) || (d6 = GammaDistribution.logpdf(d4, d2, d3)) == Double.NEGATIVE_INFINITY || Math.abs((d8 = GammaDistribution.logcdf(d5 = d4 - d7 * Math.exp(d8 - d6), d2, d3)) - d) > Math.abs(d7) || i > 0 && Math.abs(d8 - d) == Math.abs(d7)); ++i) {
            d4 = d5;
        }
        return d4;
    }

    @Reference(authors="J. M. Bernando", title="Algorithm AS 103: Psi (Digamma) Function", booktitle="Statistical Algorithms")
    public static double digamma(double d) {
        if (!(d > 0.0)) {
            return Double.NaN;
        }
        if (d <= 1.0E-5) {
            return -0.5772156649015329 - 1.0 / d;
        }
        if (d > 49.0) {
            double d2 = 1.0 / (d * d);
            return Math.log(d) - 0.5 / d - d2 * (0.08333333333333333 + d2 * (0.008333333333333333 - d2 / 252.0));
        }
        return GammaDistribution.digamma(d + 1.0) - 1.0 / d;
    }

    public static double trigamma(double d) {
        if (!(d > 0.0)) {
            return Double.NaN;
        }
        if (d <= 1.0E-5) {
            return 1.0 / (d * d);
        }
        if (d > 49.0) {
            double d2 = 1.0 / (d * d);
            return 1.0 / d - d2 / 2.0 + d2 / d * (0.16666666666666666 - d2 * (0.03333333333333333 + d2 / 42.0));
        }
        return GammaDistribution.trigamma(d + 1.0) - 1.0 / (d * d);
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        public static final OptionID K_ID = new OptionID("distribution.gamma.k", "Gamma distribution k = alpha parameter.");
        public static final OptionID THETA_ID = new OptionID("distribution.gamma.theta", "Gamma distribution theta = 1/beta parameter.");
        double k;
        double theta;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            DoubleParameter doubleParameter;
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter2 = new DoubleParameter(K_ID);
            if (parameterization.grab(doubleParameter2)) {
                this.k = doubleParameter2.doubleValue();
            }
            if (parameterization.grab(doubleParameter = new DoubleParameter(THETA_ID))) {
                this.theta = doubleParameter.doubleValue();
            }
        }

        @Override
        protected GammaDistribution makeInstance() {
            return new GammaDistribution(this.k, this.theta, this.rnd);
        }
    }
}

