/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.LogGammaDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.AbstractLogMeanVarianceEstimator;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public class LogGammaLogMOMEstimator
extends AbstractLogMeanVarianceEstimator<LogGammaDistribution> {
    public static final LogGammaLogMOMEstimator STATIC = new LogGammaLogMOMEstimator();

    private LogGammaLogMOMEstimator() {
    }

    @Override
    public LogGammaDistribution estimateFromLogMeanVariance(MeanVariance meanVariance, double d) {
        double d2 = meanVariance.getMean();
        double d3 = meanVariance.getSampleVariance();
        if (d2 < Double.MIN_NORMAL || d3 < Double.MIN_NORMAL) {
            throw new ArithmeticException("Cannot estimate Gamma parameters on a distribution with zero mean or variance: " + meanVariance.toString());
        }
        double d4 = d2 / d3;
        double d5 = d2 * d4;
        if (!(d5 > 0.0) || !(d4 > 0.0)) {
            throw new ArithmeticException("LogGamma estimation produced non-positive parameter values: k=" + d5 + " theta=" + d4);
        }
        return new LogGammaDistribution(d5, d4, d - 1.0);
    }

    @Override
    public Class<? super LogGammaDistribution> getDistributionClass() {
        return LogGammaDistribution.class;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected LogGammaLogMOMEstimator makeInstance() {
            return STATIC;
        }
    }
}

