/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.NormalDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.AbstractMADEstimator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="F. R. Hampel", title="The Influence Curve and Its Role in Robust Estimation", booktitle="Journal of the American Statistical Association, June 1974, Vol. 69, No. 346", url="http://www.jstor.org/stable/10.2307/2285666")
public class NormalMADEstimator
extends AbstractMADEstimator<NormalDistribution> {
    public static NormalMADEstimator STATIC = new NormalMADEstimator();

    private NormalMADEstimator() {
    }

    @Override
    public NormalDistribution estimateFromMedianMAD(double d, double d2) {
        return new NormalDistribution(d, Math.max(1.4826022185056018 * d2, Double.MIN_NORMAL));
    }

    @Override
    public Class<? super NormalDistribution> getDistributionClass() {
        return NormalDistribution.class;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected NormalMADEstimator makeInstance() {
            return STATIC;
        }
    }
}

