/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.NormalDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.AbstractMeanVarianceEstimator;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public class NormalMOMEstimator
extends AbstractMeanVarianceEstimator<NormalDistribution> {
    public static NormalMOMEstimator STATIC = new NormalMOMEstimator();

    private NormalMOMEstimator() {
    }

    @Override
    public NormalDistribution estimateFromMeanVariance(MeanVariance meanVariance) {
        return new NormalDistribution(meanVariance.getMean(), Math.max(meanVariance.getSampleStddev(), Double.MIN_NORMAL));
    }

    @Override
    public Class<? super NormalDistribution> getDistributionClass() {
        return NormalDistribution.class;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected NormalMOMEstimator makeInstance() {
            return STATIC;
        }
    }
}

