/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.meta;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.Distribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.DistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.QuickSelect;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayLikeUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

@Reference(authors="C. Hastings, F. Mosteller, J. W. Tukey, C. P. Winsor", title="Low moments for small samples: a comparative study of order statistics", booktitle="The Annals of Mathematical Statistics, 18(3)", url="http://dx.doi.org/10.1214/aoms/1177730388")
public class WinsorisingEstimator<D extends Distribution>
implements DistributionEstimator<D> {
    private DistributionEstimator<D> inner;
    private double winsorize;

    public WinsorisingEstimator(DistributionEstimator<D> distributionEstimator, double d) {
        this.inner = distributionEstimator;
        this.winsorize = d;
    }

    @Override
    public <A> D estimate(A a, NumberArrayAdapter<?, A> numberArrayAdapter) {
        int n = numberArrayAdapter.size(a);
        int n2 = (int)((double)n * this.winsorize) >> 1;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            double d;
            dArray[i] = d = numberArrayAdapter.getDouble(a, i);
        }
        double d = QuickSelect.quickSelect(dArray, 0, n, n2);
        double d2 = QuickSelect.quickSelect(dArray, n2, n, n - 1 - n2);
        int n3 = 0;
        int n4 = n - 1;
        while (n3 < n2) {
            dArray[n3] = d;
            dArray[n4] = d2;
            ++n3;
            --n4;
        }
        return this.inner.estimate(dArray, ArrayLikeUtil.DOUBLEARRAYADAPTER);
    }

    @Override
    public Class<? super D> getDistributionClass() {
        return this.inner.getDistributionClass();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.inner.toString() + ", trim=" + this.winsorize + ")";
    }

    public static class Parameterizer<D extends Distribution>
    extends AbstractParameterizer {
        public static final OptionID INNER_ID = new OptionID("winsorize.inner", "Estimator to use on the winsorized data.");
        public static final OptionID WINSORIZE_ID = new OptionID("winsorize.winsorize", "Relative amount of data to winsorize on each end, must be 0 < winsorize < 0.5");
        private DistributionEstimator<D> inner;
        private double winsorize;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(INNER_ID, DistributionEstimator.class);
            if (parameterization.grab(objectParameter)) {
                this.inner = (DistributionEstimator)objectParameter.instantiateClass(parameterization);
            }
            DoubleParameter doubleParameter = new DoubleParameter(WINSORIZE_ID);
            doubleParameter.addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            doubleParameter.addConstraint(CommonConstraints.LESS_THAN_HALF_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.winsorize = doubleParameter.doubleValue();
            }
        }

        @Override
        protected WinsorisingEstimator<D> makeInstance() {
            return new WinsorisingEstimator<D>(this.inner, this.winsorize);
        }
    }
}

