/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.persistent;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.persistent.AbstractPageFile;
import de.lmu.ifi.dbs.elki.persistent.Page;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import de.lmu.ifi.dbs.elki.persistent.PageHeader;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class LRUCache<P extends Page>
extends AbstractPageFile<P> {
    private static final Logging LOG = Logging.getLogger(LRUCache.class);
    protected int cacheSizeBytes;
    protected int cacheSize;
    private LinkedHashMap<Integer, P> map;
    protected PageFile<P> file;

    public LRUCache(int n, PageFile<P> pageFile) {
        this.file = pageFile;
        this.cacheSizeBytes = n;
    }

    @Override
    public synchronized P readPage(int n) {
        this.countRead();
        Page page = (Page)this.map.get(n);
        if (page != null) {
            if (LOG.isDebuggingFine()) {
                LOG.debugFine("Read from cache: " + n);
            }
        } else {
            if (LOG.isDebuggingFine()) {
                LOG.debugFine("Read from backing: " + n);
            }
            page = this.file.readPage(n);
            this.map.put(n, page);
        }
        return (P)page;
    }

    @Override
    public synchronized void writePage(int n, P p) {
        this.countWrite();
        p.setDirty(true);
        this.map.put(n, p);
        if (LOG.isDebuggingFine()) {
            LOG.debugFine("Write to cache: " + n);
        }
    }

    @Override
    public void deletePage(int n) {
        this.countWrite();
        this.map.remove(n);
        this.file.deletePage(n);
    }

    protected void expirePage(P p) {
        if (LOG.isDebuggingFine()) {
            LOG.debugFine("Write to backing:" + p.getPageID());
        }
        if (p.isDirty()) {
            this.file.writePage(p);
        }
    }

    @Override
    public int setPageID(P p) {
        int n = this.file.setPageID(p);
        return n;
    }

    @Override
    public int getNextPageID() {
        return this.file.getNextPageID();
    }

    @Override
    public void setNextPageID(int n) {
        this.file.setNextPageID(n);
    }

    @Override
    public int getPageSize() {
        return this.file.getPageSize();
    }

    @Override
    public boolean initialize(PageHeader pageHeader) {
        boolean bl = this.file.initialize(pageHeader);
        this.cacheSize = this.cacheSizeBytes / pageHeader.getPageSize();
        if (this.cacheSize <= 0) {
            throw new AbortException("Invalid cache size: " + this.cacheSizeBytes + " / " + pageHeader.getPageSize() + " = " + this.cacheSize);
        }
        if (LOG.isDebugging()) {
            LOG.debug("LRU cache size is " + this.cacheSize + " pages.");
        }
        float f = 0.75f;
        int n = (int)Math.ceil((float)this.cacheSize / f) + 1;
        this.map = new LinkedHashMap<Integer, P>(n, f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<Integer, P> entry) {
                if (this.size() > LRUCache.this.cacheSize) {
                    LRUCache.this.expirePage((Page)entry.getValue());
                    return true;
                }
                return false;
            }
        };
        return bl;
    }

    @Override
    public void close() {
        this.flush();
        this.file.close();
    }

    public void flush() {
        for (Page page : this.map.values()) {
            this.expirePage(page);
        }
        this.map.clear();
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public void setCacheSize(int n) {
        this.cacheSize = n;
        long l = this.map.size() - this.cacheSize;
        if (l <= 0L) {
            return;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.map.keySet());
        Collections.reverse(arrayList);
        for (Integer n2 : arrayList) {
            Page page = (Page)this.map.remove(n2);
            this.file.writePage(page);
        }
    }

    @Override
    public void logStatistics() {
        super.logStatistics();
        this.file.logStatistics();
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }
}

