/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.persistent;

import de.lmu.ifi.dbs.elki.utilities.io.ByteArrayUtil;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

public class OnDiskArray {
    private static final long serialVersionUID = 7586497243452875056L;
    protected int magic;
    private int headersize;
    private int recordsize;
    private int numrecs;
    private File filename;
    private final RandomAccessFile file;
    private FileLock lock = null;
    private boolean writable;
    private MappedByteBuffer map;
    private static final int INTERNAL_HEADER_SIZE = 16;
    private static final int HEADER_POS_SIZE = 12;

    public OnDiskArray(File file, int n, int n2, int n3, int n4) throws IOException {
        this.magic = OnDiskArray.mixMagic(1165828400, n);
        this.headersize = n2 + 16;
        this.recordsize = n3;
        this.filename = file;
        this.writable = true;
        if (file.exists() && file.length() > 0L) {
            throw new IOException("File already exists");
        }
        this.file = new RandomAccessFile(file, "rw");
        this.lock = this.file.getChannel().lock();
        this.file.writeInt(this.magic);
        this.file.writeInt(this.headersize);
        this.file.writeInt(this.recordsize);
        if (this.file.getFilePointer() != 12L) {
            throw new IOException("File position doesn't match when writing file size.");
        }
        this.file.writeInt(n4);
        if (this.file.getFilePointer() != 16L) {
            throw new IOException("File position doesn't match header size after writing header.");
        }
        this.resizeFile(n4);
        this.mapArray();
    }

    public OnDiskArray(File file, int n, int n2, int n3, boolean bl) throws IOException {
        this.magic = OnDiskArray.mixMagic(1165828400, n);
        this.headersize = n2 + 16;
        this.recordsize = n3;
        this.filename = file;
        this.writable = bl;
        String string = bl ? "rw" : "r";
        this.file = new RandomAccessFile(file, string);
        if (bl) {
            this.lock = this.file.getChannel().lock();
        }
        this.validateHeader(true);
        this.mapArray();
    }

    public OnDiskArray(File file, int n, int n2, boolean bl) throws IOException {
        this.magic = OnDiskArray.mixMagic(1165828400, n);
        this.headersize = n2 + 16;
        this.filename = file;
        this.writable = bl;
        String string = bl ? "rw" : "r";
        this.file = new RandomAccessFile(file, string);
        if (bl) {
            this.lock = this.file.getChannel().lock();
        }
        this.validateHeader(false);
        this.mapArray();
    }

    private synchronized void mapArray() throws IOException {
        if (this.map != null) {
            ByteArrayUtil.unmapByteBuffer(this.map);
            this.map = null;
        }
        FileChannel.MapMode mapMode = this.writable ? FileChannel.MapMode.READ_WRITE : FileChannel.MapMode.READ_ONLY;
        this.map = this.file.getChannel().map(mapMode, this.headersize, this.recordsize * this.numrecs);
    }

    private void validateHeader(boolean bl) throws IOException {
        int n = this.file.readInt();
        if (n != this.magic) {
            this.file.close();
            throw new IOException("Magic in LinearDiskCache does not match: " + n + " instead of " + this.magic);
        }
        if (this.file.readInt() != this.headersize) {
            this.file.close();
            throw new IOException("Header size in LinearDiskCache does not match.");
        }
        if (bl) {
            if (this.file.readInt() != this.recordsize) {
                this.file.close();
                throw new IOException("Recordsize in LinearDiskCache does not match.");
            }
        } else {
            this.recordsize = this.file.readInt();
        }
        if (this.file.getFilePointer() != 12L) {
            throw new IOException("Incorrect file position when reading header.");
        }
        this.numrecs = this.file.readInt();
        if (this.numrecs < 0 || this.file.length() != this.indexToFileposition(this.numrecs)) {
            throw new IOException("File size and number of records do not agree.");
        }
        if (this.file.getFilePointer() != 16L) {
            throw new IOException("Incorrect file position after reading header.");
        }
    }

    public static final int mixMagic(int n, int n2) {
        long l = 1L;
        l = 2654435761L * l + (long)n;
        l = 2654435761L * l + (long)n2;
        return (int)l;
    }

    private long indexToFileposition(long l) {
        long l2 = (long)this.headersize + l * (long)this.recordsize;
        return l2;
    }

    public synchronized void resizeFile(int n) throws IOException {
        if (!this.writable) {
            throw new IOException("File is not writeable!");
        }
        this.numrecs = n;
        this.file.seek(12L);
        this.file.writeInt(this.numrecs);
        this.file.setLength(this.indexToFileposition(this.numrecs));
        this.mapArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ByteBuffer getRecordBuffer(int n) throws IOException {
        if (n < 0 || n >= this.numrecs) {
            throw new IOException("Access beyond end of file.");
        }
        MappedByteBuffer mappedByteBuffer = this.map;
        synchronized (mappedByteBuffer) {
            this.map.limit(this.recordsize * (n + 1));
            this.map.position(this.recordsize * n);
            return this.map.slice();
        }
    }

    protected int getExtraHeaderSize() {
        return this.headersize - 16;
    }

    public synchronized ByteBuffer getExtraHeader() throws IOException {
        int n = this.headersize - 16;
        FileChannel.MapMode mapMode = this.writable ? FileChannel.MapMode.READ_WRITE : FileChannel.MapMode.READ_ONLY;
        return this.file.getChannel().map(mapMode, 16L, n);
    }

    protected int getRecordsize() {
        return this.recordsize;
    }

    public File getFilename() {
        return this.filename;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public synchronized void close() throws IOException {
        this.writable = false;
        if (this.lock != null) {
            this.lock.release();
            this.lock = null;
        }
        this.file.close();
    }

    public int getNumRecords() {
        return this.numrecs;
    }

    public void ensureSize(int n) throws IOException {
        if (n > this.getNumRecords()) {
            this.resizeFile(n);
        }
    }
}

