/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.heap;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.DoubleObjectHeap;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.Iter;
import java.util.Arrays;

public class DoubleObjectMinHeap<V>
implements DoubleObjectHeap<V> {
    protected double[] twoheap;
    protected Object[] twovals;
    protected int size;
    private static final int TWO_HEAP_INITIAL_SIZE = 31;

    public DoubleObjectMinHeap() {
        double[] dArray = new double[31];
        Object[] objectArray = new Object[31];
        this.twoheap = dArray;
        this.twovals = objectArray;
    }

    public DoubleObjectMinHeap(int n) {
        int n2 = MathUtil.nextPow2Int(n + 1) - 1;
        double[] dArray = new double[n2];
        Object[] objectArray = new Object[n2];
        this.twoheap = dArray;
        this.twovals = objectArray;
    }

    @Override
    public void clear() {
        this.size = 0;
        Arrays.fill(this.twoheap, 0.0);
        Arrays.fill(this.twovals, null);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void add(double d, V v) {
        double d2 = d;
        V v2 = v;
        if (this.size >= this.twoheap.length) {
            this.twoheap = Arrays.copyOf(this.twoheap, this.twoheap.length + this.twoheap.length + 1);
            this.twovals = Arrays.copyOf(this.twovals, this.twovals.length + this.twovals.length + 1);
        }
        int n = this.size++;
        this.twoheap[n] = d2;
        this.twovals[n] = v2;
        this.heapifyUp(n, d2, v2);
    }

    @Override
    public void add(double d, V v, int n) {
        if (this.size < n) {
            this.add(d, v);
        } else if (this.twoheap[0] < d) {
            this.replaceTopElement(d, v);
        }
    }

    @Override
    public void replaceTopElement(double d, V v) {
        this.heapifyDown(d, v);
    }

    private void heapifyUp(int n, double d, Object object) {
        int n2;
        double d2;
        while (n > 0 && !(d >= (d2 = this.twoheap[n2 = n - 1 >>> 1]))) {
            this.twoheap[n] = d2;
            this.twovals[n] = this.twovals[n2];
            n = n2;
        }
        this.twoheap[n] = d;
        this.twovals[n] = object;
    }

    @Override
    public void poll() {
        --this.size;
        if (this.size > 0) {
            double d = this.twoheap[this.size];
            Object object = this.twovals[this.size];
            this.twoheap[this.size] = 0.0;
            this.twovals[this.size] = null;
            this.heapifyDown(d, object);
        } else {
            this.twoheap[0] = 0.0;
            this.twovals[0] = null;
        }
    }

    private void heapifyDown(double d, Object object) {
        int n = this.size >>> 1;
        int n2 = 0;
        while (n2 < n) {
            int n3 = (n2 << 1) + 1;
            double d2 = this.twoheap[n3];
            int n4 = n3 + 1;
            if (n4 < this.size && d2 > this.twoheap[n4]) {
                n3 = n4;
                d2 = this.twoheap[n4];
            }
            if (d <= d2) break;
            this.twoheap[n2] = d2;
            this.twovals[n2] = this.twovals[n3];
            n2 = n3;
        }
        this.twoheap[n2] = d;
        this.twovals[n2] = object;
    }

    @Override
    public double peekKey() {
        return this.twoheap[0];
    }

    @Override
    public V peekValue() {
        return (V)this.twovals[0];
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DoubleObjectMinHeap.class.getSimpleName()).append(" [");
        UnsortedIter unsortedIter = new UnsortedIter();
        while (unsortedIter.valid()) {
            stringBuilder.append(unsortedIter.getKey()).append(':').append(unsortedIter.getValue()).append(',');
            unsortedIter.advance();
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public UnsortedIter unsortedIter() {
        return new UnsortedIter();
    }

    private class UnsortedIter
    implements DoubleObjectHeap.UnsortedIter<V> {
        protected int pos = 0;

        private UnsortedIter() {
        }

        @Override
        public boolean valid() {
            return this.pos < DoubleObjectMinHeap.this.size;
        }

        @Override
        public Iter advance() {
            ++this.pos;
            return this;
        }

        @Override
        public double getKey() {
            return DoubleObjectMinHeap.this.twoheap[this.pos];
        }

        @Override
        public V getValue() {
            return DoubleObjectMinHeap.this.twovals[this.pos];
        }
    }
}

