/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.histogram;

import de.lmu.ifi.dbs.elki.utilities.datastructures.histogram.AbstractStaticHistogram;
import de.lmu.ifi.dbs.elki.utilities.datastructures.histogram.FloatHistogram;
import java.util.Arrays;

public class FloatStaticHistogram
extends AbstractStaticHistogram
implements FloatHistogram {
    float[] data;

    public FloatStaticHistogram(int n, double d, double d2) {
        super(n, d, d2);
        this.data = (float[])(n >= 0 ? new float[n] : null);
    }

    @Override
    public void increment(double d, float f) {
        int n = this.getBinNr(d);
        if (n < 0) {
            if (this.size - n > this.data.length) {
                float[] fArray = new float[FloatStaticHistogram.growSize(this.data.length, this.size - n)];
                System.arraycopy(this.data, 0, fArray, -n, this.size);
                this.data = fArray;
            } else {
                System.arraycopy(this.data, 0, this.data, -n, this.size);
                Arrays.fill(this.data, 0, -n, 0.0f);
            }
            this.data[0] = f;
            assert (this.data.length >= this.size - n);
            this.offset -= n;
            this.size -= n;
        } else if (n >= this.data.length) {
            float[] fArray = new float[FloatStaticHistogram.growSize(this.data.length, n + 1)];
            System.arraycopy(this.data, 0, fArray, 0, this.size);
            fArray[n] = f;
            this.data = fArray;
            this.size = n + 1;
            this.max = Double.MAX_VALUE;
        } else {
            if (n >= this.size) {
                this.size = n + 1;
            }
            int n2 = n;
            this.data[n2] = this.data[n2] + f;
        }
    }

    public float get(double d) {
        int n = this.getBinNr(d);
        if (n < 0 || n >= this.size) {
            return 0.0f;
        }
        return this.data[n];
    }

    @Override
    public Iter iter() {
        return new Iter();
    }

    public class Iter
    extends AbstractStaticHistogram.Iter
    implements FloatHistogram.Iter {
        public Iter() {
            super(FloatStaticHistogram.this);
        }

        @Override
        public float getValue() {
            return FloatStaticHistogram.this.data[this.bin];
        }
    }
}

