/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.io;

import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;
import de.lmu.ifi.dbs.elki.utilities.io.FixedSizeByteBufferSerializer;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.security.AccessController;
import java.security.PrivilegedAction;

public final class ByteArrayUtil {
    public static final int SIZE_BYTE = 1;
    public static final int SIZE_SHORT = 2;
    public static final int SIZE_INT = 4;
    public static final int SIZE_LONG = 8;
    public static final int SIZE_FLOAT = 4;
    public static final int SIZE_DOUBLE = 8;
    public static final ByteSerializer BYTE_SERIALIZER = new ByteSerializer();
    public static final ShortSerializer SHORT_SERIALIZER = new ShortSerializer();
    public static final IntegerSerializer INT_SERIALIZER = new IntegerSerializer();
    public static final LongSerializer LONG_SERIALIZER = new LongSerializer();
    public static final FloatSerializer FLOAT_SERIALIZER = new FloatSerializer();
    public static final DoubleSerializer DOUBLE_SERIALIZER = new DoubleSerializer();
    public static final StringSerializer STRING_SERIALIZER = new StringSerializer();
    public static final VarintSerializer VARINT_SERIALIZER = new VarintSerializer();

    private ByteArrayUtil() {
    }

    public static int writeShort(byte[] byArray, int n, int n2) {
        byArray[n + 0] = (byte)(n2 >>> 8);
        byArray[n + 1] = (byte)(n2 >>> 0);
        return 2;
    }

    public static int writeInt(byte[] byArray, int n, int n2) {
        byArray[n + 0] = (byte)(n2 >>> 24);
        byArray[n + 1] = (byte)(n2 >>> 16);
        byArray[n + 2] = (byte)(n2 >>> 8);
        byArray[n + 3] = (byte)(n2 >>> 0);
        return 4;
    }

    public static int writeLong(byte[] byArray, int n, long l) {
        byArray[n + 0] = (byte)(l >>> 56);
        byArray[n + 1] = (byte)(l >>> 48);
        byArray[n + 2] = (byte)(l >>> 40);
        byArray[n + 3] = (byte)(l >>> 32);
        byArray[n + 4] = (byte)(l >>> 24);
        byArray[n + 5] = (byte)(l >>> 16);
        byArray[n + 6] = (byte)(l >>> 8);
        byArray[n + 7] = (byte)(l >>> 0);
        return 8;
    }

    public static int writeFloat(byte[] byArray, int n, float f) {
        return ByteArrayUtil.writeInt(byArray, n, Float.floatToIntBits(f));
    }

    public static int writeDouble(byte[] byArray, int n, double d) {
        return ByteArrayUtil.writeLong(byArray, n, Double.doubleToLongBits(d));
    }

    public static short readShort(byte[] byArray, int n) {
        int n2 = byArray[n + 0] & 0xFF;
        int n3 = byArray[n + 1] & 0xFF;
        return (short)((n2 << 8) + (n3 << 0));
    }

    public static int readUnsignedShort(byte[] byArray, int n) {
        int n2 = byArray[n + 0] & 0xFF;
        int n3 = byArray[n + 1] & 0xFF;
        return (n2 << 8) + (n3 << 0);
    }

    public static int readInt(byte[] byArray, int n) {
        int n2 = byArray[n + 0] & 0xFF;
        int n3 = byArray[n + 1] & 0xFF;
        int n4 = byArray[n + 2] & 0xFF;
        int n5 = byArray[n + 3] & 0xFF;
        return (n2 << 24) + (n3 << 16) + (n4 << 8) + (n5 << 0);
    }

    public static long readLong(byte[] byArray, int n) {
        long l = byArray[n + 0];
        long l2 = byArray[n + 1] & 0xFF;
        long l3 = byArray[n + 2] & 0xFF;
        long l4 = byArray[n + 3] & 0xFF;
        long l5 = byArray[n + 4] & 0xFF;
        int n2 = byArray[n + 5] & 0xFF;
        int n3 = byArray[n + 6] & 0xFF;
        int n4 = byArray[n + 7] & 0xFF;
        return (l << 56) + (l2 << 48) + (l3 << 40) + (l4 << 32) + (l5 << 24) + (long)(n2 << 16) + (long)(n3 << 8) + (long)(n4 << 0);
    }

    public static float readFloat(byte[] byArray, int n) {
        return Float.intBitsToFloat(ByteArrayUtil.readInt(byArray, n));
    }

    public static double readDouble(byte[] byArray, int n) {
        return Double.longBitsToDouble(ByteArrayUtil.readLong(byArray, n));
    }

    public static void writeSignedVarint(ByteBuffer byteBuffer, int n) {
        ByteArrayUtil.writeUnsignedVarint(byteBuffer, n << 1 ^ n >> 31);
    }

    public static void writeSignedVarintLong(ByteBuffer byteBuffer, long l) {
        ByteArrayUtil.writeUnsignedVarintLong(byteBuffer, l << 1 ^ l >> 63);
    }

    public static void writeUnsignedVarint(ByteBuffer byteBuffer, int n) {
        while ((n & 0x7F) != n) {
            byteBuffer.put((byte)(n & 0x7F | 0x80));
            n >>>= 7;
        }
        byteBuffer.put((byte)(n & 0x7F));
    }

    public static void writeUnsignedVarintLong(ByteBuffer byteBuffer, long l) {
        while ((l & 0x7FL) != l) {
            byteBuffer.put((byte)(l & 0x7FL | 0x80L));
            l >>>= 7;
        }
        byteBuffer.put((byte)(l & 0x7FL));
    }

    public static void writeString(ByteBuffer byteBuffer, String string) {
        if (string == null) {
            string = "";
        }
        STRING_SERIALIZER.toByteBuffer(byteBuffer, string);
    }

    public static int getSignedVarintSize(int n) {
        return ByteArrayUtil.getUnsignedVarintSize(n << 1 ^ n >> 31);
    }

    public static int getUnsignedVarintSize(int n) {
        int n2 = 1;
        while ((n & 0x7F) != n) {
            ++n2;
            n >>>= 7;
        }
        return n2;
    }

    public static int getSignedVarintLongSize(long l) {
        return ByteArrayUtil.getUnsignedVarintLongSize(l << 1 ^ l >> 31);
    }

    public static int getUnsignedVarintLongSize(long l) {
        int n = 1;
        while ((l & 0x7FL) != l) {
            ++n;
            l >>>= 7;
        }
        return n;
    }

    public static int getStringSize(String string) {
        return STRING_SERIALIZER.getByteSize(string);
    }

    public static int readSignedVarint(ByteBuffer byteBuffer) {
        int n = ByteArrayUtil.readUnsignedVarint(byteBuffer);
        return n >>> 1 ^ -(n & 1);
    }

    public static int readUnsignedVarint(ByteBuffer byteBuffer) {
        int n = 0;
        int n2 = 0;
        do {
            byte by = byteBuffer.get();
            n |= (by & 0x7F) << n2;
            if ((by & 0x80) != 0) continue;
            return n;
        } while ((n2 += 7) <= 35);
        throw new AbortException("Variable length quantity is too long for expected integer.");
    }

    public static long readSignedVarintLong(ByteBuffer byteBuffer) {
        long l = ByteArrayUtil.readUnsignedVarintLong(byteBuffer);
        return l >>> 1 ^ -(l & 1L);
    }

    public static long readUnsignedVarintLong(ByteBuffer byteBuffer) {
        long l = 0L;
        int n = 0;
        do {
            byte by = byteBuffer.get();
            l |= (long)((by & 0x7F) << n);
            if ((by & 0x80) != 0) continue;
            return l;
        } while ((n += 7) <= 63);
        throw new AbortException("Variable length quantity is too long for expected integer.");
    }

    public static String readString(ByteBuffer byteBuffer) {
        return STRING_SERIALIZER.fromByteBuffer(byteBuffer);
    }

    public static void unmapByteBuffer(final MappedByteBuffer mappedByteBuffer) {
        if (mappedByteBuffer == null) {
            return;
        }
        mappedByteBuffer.force();
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Method method = mappedByteBuffer.getClass().getMethod("cleaner", new Class[0]);
                    if (method == null) {
                        return null;
                    }
                    method.setAccessible(true);
                    Object object = method.invoke((Object)mappedByteBuffer, new Object[0]);
                    Method method2 = object.getClass().getMethod("clean", new Class[0]);
                    if (method2 == null) {
                        return null;
                    }
                    method2.invoke(object, new Object[0]);
                }
                catch (Exception exception) {
                    LoggingUtil.exception(exception);
                }
                return null;
            }
        });
    }

    public static final class VarintSerializer
    implements ByteBufferSerializer<Integer> {
        private VarintSerializer() {
        }

        @Override
        @Deprecated
        public Integer fromByteBuffer(ByteBuffer byteBuffer) {
            return ByteArrayUtil.readSignedVarint(byteBuffer);
        }

        @Override
        @Deprecated
        public void toByteBuffer(ByteBuffer byteBuffer, Integer n) {
            ByteArrayUtil.writeSignedVarint(byteBuffer, n);
        }

        @Override
        @Deprecated
        public int getByteSize(Integer n) {
            return ByteArrayUtil.getSignedVarintSize(n);
        }
    }

    public static final class StringSerializer
    implements ByteBufferSerializer<String> {
        Charset charset = Charset.forName("UTF-8");
        CharsetEncoder encoder = this.charset.newEncoder();
        CharsetDecoder decoder = this.charset.newDecoder();

        private StringSerializer() {
        }

        @Override
        public String fromByteBuffer(ByteBuffer byteBuffer) {
            CharBuffer charBuffer;
            int n = ByteArrayUtil.readUnsignedVarint(byteBuffer);
            ByteBuffer byteBuffer2 = byteBuffer.slice();
            byteBuffer2.limit(n);
            try {
                charBuffer = this.decoder.decode(byteBuffer2);
            }
            catch (CharacterCodingException characterCodingException) {
                throw new AbortException("String not representable as UTF-8.", characterCodingException);
            }
            byteBuffer.position(byteBuffer.position() + n);
            return charBuffer.toString();
        }

        @Override
        public void toByteBuffer(ByteBuffer byteBuffer, String string) {
            ByteBuffer byteBuffer2;
            try {
                byteBuffer2 = this.encoder.encode(CharBuffer.wrap(string));
            }
            catch (CharacterCodingException characterCodingException) {
                throw new AbortException("String not representable as UTF-8.", characterCodingException);
            }
            ByteArrayUtil.writeUnsignedVarint(byteBuffer, byteBuffer2.remaining());
            byteBuffer.put(byteBuffer2);
        }

        @Override
        public int getByteSize(String string) {
            try {
                int n = this.encoder.encode(CharBuffer.wrap(string)).remaining();
                return ByteArrayUtil.getUnsignedVarintSize(n) + n;
            }
            catch (CharacterCodingException characterCodingException) {
                throw new AbortException("String not representable as UTF-8.", characterCodingException);
            }
        }
    }

    public static final class DoubleSerializer
    implements FixedSizeByteBufferSerializer<Double> {
        private DoubleSerializer() {
        }

        @Override
        @Deprecated
        public Double fromByteBuffer(ByteBuffer byteBuffer) {
            return byteBuffer.getDouble();
        }

        @Override
        @Deprecated
        public void toByteBuffer(ByteBuffer byteBuffer, Double d) {
            byteBuffer.putDouble(d);
        }

        @Override
        @Deprecated
        public int getByteSize(Double d) {
            return this.getFixedByteSize();
        }

        @Override
        public int getFixedByteSize() {
            return 8;
        }
    }

    public static final class FloatSerializer
    implements FixedSizeByteBufferSerializer<Float> {
        private FloatSerializer() {
        }

        @Override
        @Deprecated
        public Float fromByteBuffer(ByteBuffer byteBuffer) {
            return Float.valueOf(byteBuffer.getFloat());
        }

        @Override
        @Deprecated
        public void toByteBuffer(ByteBuffer byteBuffer, Float f) {
            byteBuffer.putFloat(f.floatValue());
        }

        @Override
        @Deprecated
        public int getByteSize(Float f) {
            return this.getFixedByteSize();
        }

        @Override
        public int getFixedByteSize() {
            return 4;
        }
    }

    public static final class LongSerializer
    implements FixedSizeByteBufferSerializer<Long> {
        private LongSerializer() {
        }

        @Override
        @Deprecated
        public Long fromByteBuffer(ByteBuffer byteBuffer) {
            return byteBuffer.getLong();
        }

        @Override
        @Deprecated
        public void toByteBuffer(ByteBuffer byteBuffer, Long l) {
            byteBuffer.putLong(l);
        }

        @Override
        @Deprecated
        public int getByteSize(Long l) {
            return this.getFixedByteSize();
        }

        @Override
        public int getFixedByteSize() {
            return 8;
        }
    }

    public static final class IntegerSerializer
    implements FixedSizeByteBufferSerializer<Integer> {
        private IntegerSerializer() {
        }

        @Override
        @Deprecated
        public Integer fromByteBuffer(ByteBuffer byteBuffer) {
            return byteBuffer.getInt();
        }

        @Override
        @Deprecated
        public void toByteBuffer(ByteBuffer byteBuffer, Integer n) {
            byteBuffer.putInt(n);
        }

        @Override
        @Deprecated
        public int getByteSize(Integer n) {
            return this.getFixedByteSize();
        }

        @Override
        public int getFixedByteSize() {
            return 4;
        }
    }

    public static final class ShortSerializer
    implements FixedSizeByteBufferSerializer<Short> {
        private ShortSerializer() {
        }

        @Override
        @Deprecated
        public Short fromByteBuffer(ByteBuffer byteBuffer) {
            return byteBuffer.getShort();
        }

        @Override
        @Deprecated
        public void toByteBuffer(ByteBuffer byteBuffer, Short s) {
            byteBuffer.putShort(s);
        }

        @Override
        @Deprecated
        public int getByteSize(Short s) {
            return this.getFixedByteSize();
        }

        @Override
        public int getFixedByteSize() {
            return 2;
        }
    }

    public static final class ByteSerializer
    implements FixedSizeByteBufferSerializer<Byte> {
        private ByteSerializer() {
        }

        @Override
        @Deprecated
        public Byte fromByteBuffer(ByteBuffer byteBuffer) {
            return byteBuffer.get();
        }

        @Override
        @Deprecated
        public void toByteBuffer(ByteBuffer byteBuffer, Byte by) {
            byteBuffer.put(by);
        }

        @Override
        @Deprecated
        public int getByteSize(Byte by) {
            return this.getFixedByteSize();
        }

        @Override
        public int getFixedByteSize() {
            return 1;
        }
    }
}

