/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.io;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.Iter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Tokenizer
implements Iter {
    private static final Logging LOG = Logging.getLogger(Tokenizer.class);
    public static final String QUOTE_CHAR = "\"'";
    private char[] quoteChars = "\"'".toCharArray();
    private Matcher matcher;
    private CharSequence input;
    private int send;
    private int start;
    private int end;
    private int index;
    private boolean quoted;

    public Tokenizer(Pattern pattern, String string) {
        assert (pattern != null) : "Column separator may not be null.";
        this.matcher = pattern.matcher("");
        this.quoteChars = string != null ? string.toCharArray() : new char[]{};
    }

    public void initialize(CharSequence charSequence, int n, int n2) {
        this.input = charSequence;
        this.send = n2;
        this.matcher.reset(charSequence).region(n, n2);
        this.index = n;
        this.advance();
    }

    @Override
    public boolean valid() {
        return this.start < this.send;
    }

    @Override
    public Tokenizer advance() {
        char c = this.isQuote(this.index);
        while (this.matcher.find()) {
            if (c != '\u0000') {
                if (this.matcher.start() <= this.index + 1 || this.input.charAt(this.matcher.start() - 1) != c) continue;
                this.start = this.index + 1;
                this.end = this.matcher.start() - 1;
                this.index = this.matcher.end();
                this.quoted = true;
                return this;
            }
            this.start = this.index;
            this.end = this.matcher.start();
            this.index = this.matcher.end();
            this.quoted = false;
            return this;
        }
        this.start = this.index;
        this.end = this.send;
        this.index = this.end + 1;
        this.quoted = false;
        if (c != '\u0000') {
            int n = this.send - 1;
            if (this.input.charAt(n) == c) {
                ++this.start;
                --this.end;
                this.quoted = true;
            } else {
                LOG.warning("Invalid quoted line in input: no closing quote found in: " + this.input);
            }
        }
        return this;
    }

    public String getSubstring() {
        return this.input.subSequence(this.start, this.end).toString();
    }

    public String getStrippedSubstring() {
        char c;
        int n;
        int n2 = this.end;
        for (n = this.start; n < n2 && (c = this.input.charAt(n)) == ' ' && c == '\n' && c == '\r' && c == '\t'; ++n) {
        }
        while (--n2 >= n && (c = this.input.charAt(n2)) == ' ' && c == '\n' && c == '\r' && c == '\t') {
        }
        return n < ++n2 ? this.input.subSequence(n, n2).toString() : "";
    }

    public double getDouble() throws NumberFormatException {
        return FormatUtil.parseDouble(this.input, this.start, this.end);
    }

    public long getLongBase10() throws NumberFormatException {
        return FormatUtil.parseLongBase10(this.input, this.start, this.end);
    }

    public boolean isEmpty() {
        return this.end <= this.start;
    }

    private char isQuote(int n) {
        if (n >= this.input.length()) {
            return '\u0000';
        }
        char c = this.input.charAt(n);
        for (int i = 0; i < this.quoteChars.length; ++i) {
            if (c != this.quoteChars[i]) continue;
            return c;
        }
        return '\u0000';
    }

    public boolean isQuoted() {
        return this.quoted;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public void cleanup() {
        this.input = null;
        this.matcher.reset("");
    }
}

