/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints;

import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;

public class StringLengthConstraint
implements ParameterConstraint<String> {
    int minlength;
    int maxlength;

    public StringLengthConstraint(int n, int n2) {
        this.minlength = n;
        this.maxlength = n2;
    }

    @Override
    public void test(String string) throws ParameterException {
        if (string.length() < this.minlength) {
            throw new WrongParameterValueException("Parameter Constraint Error.\nParameter value length must be at least " + this.minlength + ".");
        }
        if (this.maxlength > 0 && string.length() > this.maxlength) {
            throw new WrongParameterValueException("Parameter Constraint Error.\nParameter value length must be at most " + this.maxlength + ".");
        }
    }

    @Override
    public String getDescription(String string) {
        if (this.maxlength > 0) {
            return string + " has length " + this.minlength + " to " + this.maxlength + ".";
        }
        return string + " has length of at least " + this.minlength + ".";
    }
}

