/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters;

import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.UnspecifiedParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.AbstractParameter;
import java.util.ArrayList;
import java.util.Collection;

public class EnumParameter<E extends Enum<E>>
extends AbstractParameter<EnumParameter<E>, E> {
    protected Class<E> enumClass;

    public EnumParameter(OptionID optionID, Class<E> clazz, E e) {
        super(optionID, e);
        this.enumClass = clazz;
    }

    public EnumParameter(OptionID optionID, Class<E> clazz, boolean bl) {
        super(optionID, bl);
        this.enumClass = clazz;
    }

    public EnumParameter(OptionID optionID, Class<E> clazz) {
        super(optionID);
        this.enumClass = clazz;
    }

    @Override
    public String getSyntax() {
        return "<" + this.joinEnumNames(" | ") + ">";
    }

    @Override
    protected E parseValue(Object object) throws ParameterException {
        if (object == null) {
            throw new UnspecifiedParameterException(this);
        }
        if (this.enumClass.isInstance(object)) {
            return (E)((Enum)this.enumClass.cast(object));
        }
        if (object instanceof String) {
            try {
                return Enum.valueOf(this.enumClass, (String)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new WrongParameterValueException("Enum parameter " + this.getName() + " is invalid (must be one of [" + this.joinEnumNames(", ") + "].");
            }
        }
        throw new WrongParameterValueException("Enum parameter " + this.getName() + " is not given as a string.");
    }

    @Override
    public String getValueAsString() {
        return ((Enum)this.getValue()).name();
    }

    @Override
    public boolean hasValuesDescription() {
        return true;
    }

    @Override
    public String getValuesDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("One of:").append(FormatUtil.NEWLINE);
        for (String string : this.getPossibleValues()) {
            stringBuilder.append("->").append("\u00a0").append(string).append(FormatUtil.NEWLINE);
        }
        return stringBuilder.toString();
    }

    public Collection<String> getPossibleValues() {
        Enum[] enumArray = (Enum[])this.enumClass.getEnumConstants();
        ArrayList<String> arrayList = new ArrayList<String>(enumArray.length);
        for (Enum enum_ : enumArray) {
            arrayList.add(enum_.name());
        }
        return arrayList;
    }

    private String joinEnumNames(String string) {
        Enum[] enumArray = (Enum[])this.enumClass.getEnumConstants();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < enumArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(enumArray[i].name());
        }
        return stringBuilder.toString();
    }
}

