/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters;

import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ListParameter;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FileListParameter
extends ListParameter<FileListParameter, List<File>> {
    private FilesType filesType;

    public FileListParameter(OptionID optionID, FilesType filesType) {
        super(optionID);
        this.filesType = filesType;
    }

    @Override
    public String getValueAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        List list = (List)this.getValue();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.toString();
    }

    @Override
    public String getDefaultValueAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        List list = (List)this.getDefaultValue();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.toString();
    }

    @Override
    protected List<File> parseValue(Object object) throws ParameterException {
        try {
            List list = (List)List.class.cast(object);
            for (Object e : list) {
                if (e instanceof File) continue;
                throw new WrongParameterValueException("Wrong parameter format for parameter \"" + this.getName() + "\". Given list contains objects of different type!");
            }
            return list;
        }
        catch (ClassCastException classCastException) {
            if (object instanceof String) {
                String[] stringArray = SPLIT.split((String)object);
                ArrayList<File> arrayList = new ArrayList<File>(stringArray.length);
                for (String string : stringArray) {
                    arrayList.add(new File(string));
                }
                return arrayList;
            }
            throw new WrongParameterValueException("Wrong parameter format! Parameter \"" + this.getName() + "\" requires a list of file values!");
        }
    }

    @Override
    protected boolean validate(List<File> list) throws ParameterException {
        if (!super.validate(list)) {
            return false;
        }
        if (this.filesType.equals((Object)FilesType.INPUT_FILES)) {
            for (File file : list) {
                try {
                    if (file.exists()) continue;
                    throw new WrongParameterValueException("Given file " + file.getPath() + " for parameter \"" + this.getName() + "\" does not exist!\n");
                }
                catch (SecurityException securityException) {
                    throw new WrongParameterValueException("Given file \"" + file.getPath() + "\" cannot be read, access denied!", securityException);
                }
            }
        }
        return true;
    }

    @Override
    public int size() {
        return ((List)this.getValue()).size();
    }

    @Override
    public String getSyntax() {
        return "<file_1,...,file_n>";
    }

    public static enum FilesType {
        INPUT_FILES,
        OUTPUT_FILES;

    }
}

