/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.pairs;

import java.util.Comparator;

public class DoubleDoublePair
implements Comparable<DoubleDoublePair> {
    public double first;
    public double second;
    public static final Comparator<DoubleDoublePair> BYFIRST_COMPARATOR = new Comparator<DoubleDoublePair>(){

        @Override
        public int compare(DoubleDoublePair doubleDoublePair, DoubleDoublePair doubleDoublePair2) {
            return Double.compare(doubleDoublePair.first, doubleDoublePair2.first);
        }
    };
    public static final Comparator<DoubleDoublePair> BYSECOND_COMPARATOR = new Comparator<DoubleDoublePair>(){

        @Override
        public int compare(DoubleDoublePair doubleDoublePair, DoubleDoublePair doubleDoublePair2) {
            return Double.compare(doubleDoublePair.second, doubleDoublePair2.second);
        }
    };
    public static final Comparator<DoubleDoublePair> SWAPPED_COMPARATOR = new Comparator<DoubleDoublePair>(){

        @Override
        public int compare(DoubleDoublePair doubleDoublePair, DoubleDoublePair doubleDoublePair2) {
            return doubleDoublePair.compareSwappedTo(doubleDoublePair2);
        }
    };

    public DoubleDoublePair(double d, double d2) {
        this.first = d;
        this.second = d2;
    }

    public DoubleDoublePair(DoubleDoublePair doubleDoublePair) {
        this(doubleDoublePair.first, doubleDoublePair.second);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DoubleDoublePair doubleDoublePair = (DoubleDoublePair)object;
        return this.first == doubleDoublePair.first && this.second == doubleDoublePair.second;
    }

    public final int hashCode() {
        long l = Double.doubleToLongBits(this.first);
        l ^= l >> 32;
        long l2 = Double.doubleToLongBits(this.second);
        l2 ^= l2 >> 32;
        return (int)(l * 2654435761L + l2);
    }

    @Override
    public int compareTo(DoubleDoublePair doubleDoublePair) {
        int n = Double.compare(this.first, doubleDoublePair.first);
        if (n != 0) {
            return n;
        }
        return Double.compare(this.second, doubleDoublePair.second);
    }

    public int compareSwappedTo(DoubleDoublePair doubleDoublePair) {
        int n = Double.compare(this.second, doubleDoublePair.second);
        if (n != 0) {
            return n;
        }
        return Double.compare(this.first, doubleDoublePair.first);
    }

    public final void setFirst(double d) {
        this.first = d;
    }

    public final void setSecond(double d) {
        this.second = d;
    }

    public String toString() {
        return "DoubleDoublePair(" + this.first + "," + this.second + ")";
    }
}

