/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.referencepoints;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import de.lmu.ifi.dbs.elki.utilities.referencepoints.ReferencePointsHeuristic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;

public class RandomGeneratedReferencePoints
implements ReferencePointsHeuristic {
    protected int samplesize;
    protected double scale = 1.0;
    protected RandomFactory rnd;

    public RandomGeneratedReferencePoints(int n, double d, RandomFactory randomFactory) {
        this.samplesize = n;
        this.scale = d;
        this.rnd = randomFactory;
    }

    @Override
    public Collection<? extends NumberVector> getReferencePoints(Relation<? extends NumberVector> relation) {
        double[][] dArray = RelationUtil.computeMinMax(relation);
        int n = RelationUtil.dimensionality(relation);
        double[] dArray2 = dArray[0];
        double[] dArray3 = dArray[1];
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            dArray3[n2] = dArray3[n2] - dArray2[i];
            int n3 = i;
            dArray2[n3] = dArray2[n3] - dArray3[i] * 0.5;
        }
        Random random = this.rnd.getSingleThreadedRandom();
        ArrayList<Vector> arrayList = new ArrayList<Vector>(this.samplesize);
        double[] dArray4 = new double[n];
        for (int i = 0; i < this.samplesize; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray4[j] = dArray2[j] + (random.nextDouble() - 0.5) * this.scale * dArray3[j];
            }
            Vector vector = new Vector(dArray4);
            arrayList.add(vector);
        }
        return arrayList;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID N_ID = new OptionID("generate.n", "The number of reference points to be generated.");
        public static final OptionID SCALE_ID = new OptionID("generate.scale", "Scale the grid by the given factor. This can be used to obtain reference points outside the used data space.");
        public static final OptionID RANDOM_ID = new OptionID("generate.random", "Random generator seed.");
        protected int samplesize;
        protected double scale = 1.0;
        protected RandomFactory rnd;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            RandomParameter randomParameter;
            DoubleParameter doubleParameter;
            super.makeOptions(parameterization);
            IntParameter intParameter = (IntParameter)new IntParameter(N_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.samplesize = (Integer)intParameter.getValue();
            }
            if (parameterization.grab(doubleParameter = (DoubleParameter)new DoubleParameter(SCALE_ID, 1.0).addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE))) {
                this.scale = (Double)doubleParameter.getValue();
            }
            if (parameterization.grab(randomParameter = new RandomParameter(RANDOM_ID))) {
                this.rnd = (RandomFactory)randomParameter.getValue();
            }
        }

        @Override
        protected RandomGeneratedReferencePoints makeInstance() {
            return new RandomGeneratedReferencePoints(this.samplesize, this.scale, this.rnd);
        }
    }
}

