/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.referencepoints;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import de.lmu.ifi.dbs.elki.utilities.referencepoints.ReferencePointsHeuristic;
import java.util.ArrayList;
import java.util.Collection;

public class RandomSampleReferencePoints
implements ReferencePointsHeuristic {
    protected int samplesize;
    protected RandomFactory rnd;

    public RandomSampleReferencePoints(int n, RandomFactory randomFactory) {
        this.samplesize = n;
        this.rnd = randomFactory;
    }

    @Override
    public Collection<? extends NumberVector> getReferencePoints(Relation<? extends NumberVector> relation) {
        if (this.samplesize >= relation.size()) {
            LoggingUtil.warning("Requested sample size is larger than database size!");
            return new RelationUtil.CollectionFromRelation<NumberVector>(relation);
        }
        ModifiableDBIDs modifiableDBIDs = DBIDUtil.randomSample(relation.getDBIDs(), this.samplesize, this.rnd);
        ArrayList<NumberVector> arrayList = new ArrayList<NumberVector>(modifiableDBIDs.size());
        DBIDIter dBIDIter = modifiableDBIDs.iter();
        while (dBIDIter.valid()) {
            arrayList.add(relation.get(dBIDIter));
            dBIDIter.advance();
        }
        return arrayList;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID N_ID = new OptionID("sample.n", "The number of samples to draw.");
        public static final OptionID RANDOM_ID = new OptionID("sample.random", "Random generator seed.");
        protected int samplesize;
        protected RandomFactory rnd;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            RandomParameter randomParameter;
            super.makeOptions(parameterization);
            IntParameter intParameter = (IntParameter)new IntParameter(N_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.samplesize = intParameter.intValue();
            }
            if (parameterization.grab(randomParameter = new RandomParameter(RANDOM_ID))) {
                this.rnd = (RandomFactory)randomParameter.getValue();
            }
        }

        @Override
        protected RandomSampleReferencePoints makeInstance() {
            return new RandomSampleReferencePoints(this.samplesize, this.rnd);
        }
    }
}

