/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.scaling.outlier;

import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.OnlyOneIsAllowedToBeSetGlobalConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.OutlierScalingFunction;
import java.util.ArrayList;

public class OutlierLinearScaling
implements OutlierScalingFunction {
    public static final OptionID MIN_ID = new OptionID("linearscale.min", "Fixed minimum to use in linear scaling.");
    public static final OptionID MAX_ID = new OptionID("linearscale.max", "Fixed maximum to use in linear scaling.");
    public static final OptionID MEAN_ID = new OptionID("linearscale.usemean", "Use the mean as minimum for scaling.");
    public static final OptionID NOZEROS_ID = new OptionID("linearscale.ignorezero", "Ignore zero entries when computing the minimum and maximum.");
    protected Double min = null;
    protected Double max = null;
    double factor;
    boolean usemean = false;
    boolean nozeros = false;

    public OutlierLinearScaling() {
        this(null, null, false, false);
    }

    public OutlierLinearScaling(Double d, Double d2, boolean bl, boolean bl2) {
        this.min = d;
        this.max = d2;
        this.usemean = bl;
        this.nozeros = bl2;
        if (d != null && d2 != null) {
            this.factor = d2 - d;
        }
    }

    @Override
    public double getScaled(double d) {
        assert (this.factor != 0.0) : "prepare() was not run prior to using the scaling function.";
        if (d <= this.min) {
            return 0.0;
        }
        return Math.min(1.0, (d - this.min) / this.factor);
    }

    @Override
    public void prepare(OutlierResult outlierResult) {
        if (this.usemean) {
            MeanVariance meanVariance = new MeanVariance();
            DoubleMinMax doubleMinMax = this.max == null ? new DoubleMinMax() : null;
            boolean bl = false;
            DoubleRelation doubleRelation = outlierResult.getScores();
            DBIDIter dBIDIter = doubleRelation.iterDBIDs();
            while (dBIDIter.valid()) {
                double d = doubleRelation.doubleValue(dBIDIter);
                if (this.nozeros && d == 0.0) {
                    bl = true;
                } else {
                    if (!Double.isNaN(d) && !Double.isInfinite(d)) {
                        meanVariance.put(d);
                    }
                    if (this.max == null) {
                        doubleMinMax.put(d);
                    }
                }
                dBIDIter.advance();
            }
            if (bl && doubleMinMax.getMin() == doubleMinMax.getMax()) {
                doubleMinMax.put(0.0);
                meanVariance.put(0.0);
            }
            this.min = meanVariance.getMean();
            if (this.max == null) {
                this.max = doubleMinMax.getMax();
            }
        } else if (this.min == null || this.max == null) {
            boolean bl = false;
            DoubleMinMax doubleMinMax = new DoubleMinMax();
            DoubleRelation doubleRelation = outlierResult.getScores();
            DBIDIter dBIDIter = doubleRelation.iterDBIDs();
            while (dBIDIter.valid()) {
                double d = doubleRelation.doubleValue(dBIDIter);
                if (this.nozeros && d == 0.0) {
                    bl = true;
                } else {
                    doubleMinMax.put(d);
                }
                dBIDIter.advance();
            }
            if (bl && doubleMinMax.getMin() == doubleMinMax.getMax()) {
                doubleMinMax.put(0.0);
            }
            if (this.min == null) {
                this.min = doubleMinMax.getMin();
            }
            if (this.max == null) {
                this.max = doubleMinMax.getMax();
            }
        }
        this.factor = this.max - this.min;
    }

    @Override
    public <A> void prepare(A a, NumberArrayAdapter<?, A> numberArrayAdapter) {
        if (this.usemean) {
            MeanVariance meanVariance = new MeanVariance();
            DoubleMinMax doubleMinMax = this.max == null ? new DoubleMinMax() : null;
            boolean bl = false;
            int n = numberArrayAdapter.size(a);
            for (int i = 0; i < n; ++i) {
                double d = numberArrayAdapter.getDouble(a, i);
                if (this.nozeros && d == 0.0) {
                    bl = true;
                    continue;
                }
                if (!Double.isNaN(d) && !Double.isInfinite(d)) {
                    meanVariance.put(d);
                }
                if (this.max != null) continue;
                doubleMinMax.put(d);
            }
            if (bl && doubleMinMax.getMin() == doubleMinMax.getMax()) {
                doubleMinMax.put(0.0);
                meanVariance.put(0.0);
            }
            this.min = meanVariance.getMean();
            if (this.max == null) {
                this.max = doubleMinMax.getMax();
            }
        } else if (this.min == null || this.max == null) {
            boolean bl = false;
            DoubleMinMax doubleMinMax = new DoubleMinMax();
            int n = numberArrayAdapter.size(a);
            for (int i = 0; i < n; ++i) {
                double d = numberArrayAdapter.getDouble(a, i);
                if (this.nozeros && d == 0.0) {
                    bl = true;
                    continue;
                }
                doubleMinMax.put(d);
            }
            if (bl && doubleMinMax.getMin() == doubleMinMax.getMax()) {
                doubleMinMax.put(0.0);
            }
            if (this.min == null) {
                this.min = doubleMinMax.getMin();
            }
            if (this.max == null) {
                this.max = doubleMinMax.getMax();
            }
        }
        this.factor = this.max - this.min;
    }

    @Override
    public double getMin() {
        return 0.0;
    }

    @Override
    public double getMax() {
        return 1.0;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        protected Double min = null;
        protected Double max = null;
        boolean usemean = false;
        boolean nozeros = false;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            Flag flag;
            Flag flag2;
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter = new DoubleParameter(MIN_ID);
            doubleParameter.setOptional(true);
            if (parameterization.grab(doubleParameter)) {
                this.min = (Double)doubleParameter.getValue();
            }
            DoubleParameter doubleParameter2 = new DoubleParameter(MAX_ID);
            doubleParameter2.setOptional(true);
            if (parameterization.grab(doubleParameter2)) {
                this.max = (Double)doubleParameter2.getValue();
            }
            if (parameterization.grab(flag2 = new Flag(MEAN_ID))) {
                this.usemean = (Boolean)flag2.getValue();
            }
            if (parameterization.grab(flag = new Flag(NOZEROS_ID))) {
                this.nozeros = (Boolean)flag.getValue();
            }
            ArrayList arrayList = new ArrayList();
            arrayList.add(doubleParameter);
            arrayList.add(flag2);
            OnlyOneIsAllowedToBeSetGlobalConstraint onlyOneIsAllowedToBeSetGlobalConstraint = new OnlyOneIsAllowedToBeSetGlobalConstraint(arrayList);
            parameterization.checkConstraint(onlyOneIsAllowedToBeSetGlobalConstraint);
        }

        @Override
        protected OutlierLinearScaling makeInstance() {
            return new OutlierLinearScaling(this.min, this.max, this.usemean, this.nozeros);
        }
    }
}

