/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.batikutil;

import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.visualization.batikutil.JSVGUpdateSynchronizer;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.batik.bridge.UpdateManager;
import org.apache.batik.swing.JSVGCanvas;
import org.w3c.dom.Document;

public class JSVGSynchronizedCanvas
extends JSVGCanvas {
    private static final long serialVersionUID = 1L;
    private final JSVGUpdateSynchronizer synchronizer;
    private SVGPlot plot = null;
    private final AtomicReference<Runnable> latest = new AtomicReference();

    public JSVGSynchronizedCanvas() {
        this.synchronizer = new JSVGUpdateSynchronizer(this);
        super.setDocumentState(1);
    }

    public SVGPlot getPlot() {
        return this.plot;
    }

    @Override
    @Deprecated
    public synchronized void setDocument(Document document) {
        super.setDocument(document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlot(SVGPlot sVGPlot) {
        JSVGUpdateSynchronizer jSVGUpdateSynchronizer = this.synchronizer;
        synchronized (jSVGUpdateSynchronizer) {
            super.setSVGDocument(null);
            this.scheduleSetPlot(this.plot, sVGPlot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleSetPlot(final SVGPlot sVGPlot, final SVGPlot sVGPlot2) {
        UpdateManager updateManager = this.getUpdateManager();
        if (updateManager != null) {
            UpdateManager updateManager2 = updateManager;
            synchronized (updateManager2) {
                if (updateManager.isRunning()) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            if (JSVGSynchronizedCanvas.this.latest.compareAndSet(this, null)) {
                                JSVGSynchronizedCanvas.this.detachPlot(sVGPlot);
                                JSVGSynchronizedCanvas.this.attachPlot(sVGPlot2);
                            }
                        }
                    };
                    this.latest.set(runnable);
                    updateManager.getUpdateRunnableQueue().preemptLater(runnable);
                    return;
                }
            }
        } else if (sVGPlot != null) {
            LoggingUtil.warning("No update manager, but a previous plot exists. Incorrectly initialized?");
        }
        this.detachPlot(sVGPlot);
        this.attachPlot(sVGPlot2);
    }

    private void attachPlot(SVGPlot sVGPlot) {
        this.plot = sVGPlot;
        if (sVGPlot == null) {
            super.setSVGDocument(null);
            return;
        }
        sVGPlot.synchronizeWith(this.synchronizer);
        super.setSVGDocument(sVGPlot.getDocument());
        super.setDisableInteractions(sVGPlot.getDisableInteractions());
    }

    private void detachPlot(SVGPlot sVGPlot) {
        if (sVGPlot == null) {
            return;
        }
        this.plot = null;
        sVGPlot.unsynchronizeWith(this.synchronizer);
    }
}

