/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.gui;

import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import java.util.concurrent.ConcurrentLinkedDeque;

public class VisualizationPlot
extends SVGPlot {
    protected Runnable pendingRedraw = null;
    protected ConcurrentLinkedDeque<Visualization> updateQueue = new ConcurrentLinkedDeque();

    protected final void synchronizedRedraw() {
        Runnable runnable;
        this.pendingRedraw = runnable = new Runnable(){

            @Override
            public void run() {
                if (VisualizationPlot.this.pendingRedraw == this) {
                    VisualizationPlot.this.pendingRedraw = null;
                    VisualizationPlot.this.redraw();
                }
            }
        };
        this.scheduleUpdate(runnable);
    }

    protected void redraw() {
        while (!this.updateQueue.isEmpty()) {
            Visualization visualization = this.updateQueue.pop();
            visualization.incrementalRedraw();
        }
    }

    public void requestRedraw(VisualizationTask visualizationTask, Visualization visualization) {
        this.updateQueue.add(visualization);
        this.synchronizedRedraw();
    }
}

