/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.gui.overview;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.LoggingConfiguration;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.DoubleArray;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class RectangleArranger<T> {
    private static final Logging LOG = Logging.getLogger(RectangleArranger.class);
    private double ratio = 1.0;
    private double twidth = 1.0;
    private double theight = 1.0;
    private DoubleArray widths = new DoubleArray();
    private DoubleArray heights = new DoubleArray();
    private ArrayList<ArrayList<Object>> usage = new ArrayList();
    private Map<T, double[]> map = new HashMap<T, double[]>();

    public RectangleArranger(double d) {
        this(d, 1.0);
    }

    public RectangleArranger(double d, double d2) {
        this.ratio = d / d2;
        this.twidth = d;
        this.theight = d2;
        this.widths.add(d);
        this.heights.add(d2);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(null);
        this.usage.add(arrayList);
        this.assertConsistent();
    }

    public void put(double d, double d2, T t) {
        int n;
        int n2;
        int n3;
        double d3;
        double d4;
        double d5;
        double d6;
        if (LOG.isDebuggingFinest()) {
            LOG.finest("Add: " + d + "x" + d2);
        }
        int n4 = this.widths.size();
        int n5 = this.heights.size();
        int n6 = -1;
        int n7 = -1;
        int n8 = n4 - 1;
        int n9 = -1;
        double d7 = this.computeIncreaseArea(d, Math.max(0.0, d2 - this.theight));
        if (d7 < (d6 = this.computeIncreaseArea(Math.max(0.0, d - this.twidth), d2))) {
            d5 = d;
            d4 = Math.max(0.0, d2 - this.theight);
            d3 = d7;
        } else {
            d5 = Math.max(0.0, d - this.twidth);
            d4 = d2;
            d3 = d6;
        }
        for (n3 = 0; n3 < n5; ++n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                if (this.usage.get(n3).get(n2) != null) continue;
                d6 = this.widths.get(n2);
                double d8 = this.heights.get(n3);
                int n10 = n2;
                int n11 = n3;
                while (d6 < d || d8 < d2) {
                    int n12;
                    boolean bl;
                    if (d6 / d8 < d / d2) {
                        if (d6 < d && n10 + 1 < n4) {
                            bl = true;
                            for (n12 = n3; n12 <= n11; ++n12) {
                                if (this.usage.get(n12).get(n10 + 1) == null) continue;
                                bl = false;
                            }
                            if (bl) {
                                d6 += this.widths.get(++n10);
                                continue;
                            }
                        }
                        if (!(d8 < d2) || n11 + 1 >= n5) break;
                        bl = true;
                        for (n12 = n2; n12 <= n10; ++n12) {
                            if (this.usage.get(n11 + 1).get(n12) == null) continue;
                            bl = false;
                        }
                        if (!bl) break;
                        d8 += this.heights.get(++n11);
                        continue;
                    }
                    if (d8 < d2 && n11 + 1 < n5) {
                        bl = true;
                        for (n12 = n2; n12 <= n10; ++n12) {
                            if (this.usage.get(n11 + 1).get(n12) == null) continue;
                            bl = false;
                        }
                        if (bl) {
                            d8 += this.heights.get(++n11);
                            continue;
                        }
                    }
                    if (!(d6 < d) || n10 + 1 >= n4) break;
                    bl = true;
                    for (n12 = n3; n12 <= n11; ++n12) {
                        if (this.usage.get(n12).get(n10 + 1) == null) continue;
                        bl = false;
                    }
                    if (!bl) break;
                    d6 += this.widths.get(++n10);
                }
                if (d6 < d && n10 < n4 - 1 || d8 < d2 && n11 < n5 - 1) continue;
                double d9 = Math.max(0.0, d - d6);
                double d10 = Math.max(0.0, d2 - d8);
                double d11 = this.computeIncreaseArea(d9, d10);
                if (LOG.isDebuggingFinest()) {
                    LOG.debugFinest("Candidate: " + n2 + "," + n3 + " - " + n10 + "," + n11 + ": " + d6 + "x" + d8 + " " + d11);
                }
                if (d11 < d3) {
                    d3 = d11;
                    n6 = n2;
                    n7 = n3;
                    n8 = n10;
                    n9 = n11;
                    d5 = d - d6;
                    d4 = d2 - d8;
                }
                if (d11 == 0.0) break;
            }
            assert (this.assertConsistent());
        }
        if (LOG.isDebuggingFinest()) {
            LOG.debugFinest("Best: " + n6 + "," + n7 + " - " + n8 + "," + n9 + " inc: " + d5 + "x" + d4 + " " + d3);
        }
        if (d3 > 0.0) {
            assert (n8 == n4 - 1 || n9 == n5 - 1);
            double d12 = Math.max(d5, d4 * this.ratio);
            this.resize(d12);
            this.put(d, d2, t);
            return;
        }
        if (d5 < 0.0) {
            this.splitCol(n8, -d5);
            d5 = 0.0;
        }
        if (d4 < 0.0) {
            this.splitRow(n9, -d4);
            d4 = 0.0;
        }
        for (n3 = n6; n3 <= n8; ++n3) {
            for (n2 = n7; n2 <= n9; ++n2) {
                this.usage.get(n2).set(n3, t);
            }
        }
        double d13 = 0.0;
        d6 = 0.0;
        for (n = 0; n < n6; ++n) {
            d13 += this.widths.get(n);
        }
        for (n = 0; n < n7; ++n) {
            d6 += this.heights.get(n);
        }
        this.map.put(t, new double[]{d13, d6, d, d2});
        if (LOG.isDebuggingFinest()) {
            this.logSizes();
        }
    }

    protected double computeIncreaseArea(double d, double d2) {
        double d3 = Math.max(d, d2 * this.ratio);
        d3 *= d2 + d3 / this.ratio + d / this.ratio;
        return d3;
    }

    protected void splitRow(int n, double d) {
        assert (n < this.heights.size());
        if (this.heights.get(n) - d <= Double.MIN_NORMAL) {
            return;
        }
        if (LOG.isDebuggingFine()) {
            LOG.debugFine("Split row " + n);
        }
        this.heights.insert(n + 1, d);
        this.heights.set(n, this.heights.get(n) - d);
        this.usage.add(n + 1, new ArrayList(this.usage.get(n)));
    }

    protected void splitCol(int n, double d) {
        assert (n < this.widths.size());
        if (this.widths.get(n) - d <= Double.MIN_NORMAL) {
            return;
        }
        int n2 = this.heights.size();
        if (LOG.isDebuggingFine()) {
            LOG.debugFine("Split column " + n);
        }
        this.widths.insert(n + 1, d);
        this.widths.set(n, this.widths.get(n) - d);
        for (int i = 0; i < n2; ++i) {
            this.usage.get(i).add(n + 1, this.usage.get(i).get(n));
        }
        assert (this.assertConsistent());
    }

    private void resize(double d) {
        int n = this.widths.size();
        int n2 = this.heights.size();
        if (LOG.isDebuggingFine()) {
            LOG.debugFine("Resize by " + d + "x" + d / this.ratio);
            if (LOG.isDebuggingFinest()) {
                this.logSizes();
            }
        }
        this.widths.add(d);
        this.twidth += d;
        this.heights.add(d / this.ratio);
        this.theight += d / this.ratio;
        for (int i = 0; i < n2; ++i) {
            this.usage.get(i).add(null);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i <= n; ++i) {
            arrayList.add(null);
        }
        this.usage.add(arrayList);
        assert (this.assertConsistent());
        if (LOG.isDebuggingFinest()) {
            this.logSizes();
        }
    }

    public double[] get(T t) {
        double[] dArray = this.map.get(t);
        if (dArray == null) {
            return null;
        }
        return (double[])dArray.clone();
    }

    private boolean assertConsistent() {
        int n;
        int n2 = this.widths.size();
        int n3 = this.heights.size();
        double d = 0.0;
        for (n = 0; n < n2; ++n) {
            assert (this.widths.get(n) > 0.0) : "Non-positive width: " + this.widths.get(n) + " at " + n;
            d += this.widths.get(n);
        }
        assert (Math.abs(d - this.twidth) < 1.0E-10);
        d = 0.0;
        for (n = 0; n < n3; ++n) {
            assert (this.heights.get(n) > 0.0) : "Non-positive height: " + this.heights.get(n) + " at " + n;
            d += this.heights.get(n);
        }
        assert (Math.abs(d - this.theight) < 1.0E-10);
        assert (this.usage.size() == n3);
        for (int i = 0; i < n3; ++i) {
            assert (this.usage.get(i).size() == n2);
        }
        return true;
    }

    protected void logSizes() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = this.widths.size();
        int n3 = this.heights.size();
        stringBuilder.append("Widths: ");
        for (n = 0; n < n2; ++n) {
            if (n > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.widths.get(n));
        }
        stringBuilder.append('\n');
        stringBuilder.append("Heights: ");
        for (n = 0; n < n3; ++n) {
            if (n > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.heights.get(n));
        }
        stringBuilder.append('\n');
        for (n = 0; n < n3; ++n) {
            for (int i = 0; i < n2; ++i) {
                stringBuilder.append(this.usage.get(n).get(i) != null ? "X" : "_");
            }
            stringBuilder.append("|\n");
        }
        for (n = 0; n < n2; ++n) {
            stringBuilder.append('-');
        }
        stringBuilder.append("+\n");
        LOG.debug(stringBuilder);
    }

    public double relativeFill() {
        double d = 0.0;
        int n = this.widths.size();
        int n2 = this.heights.size();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                if (this.usage.get(i).get(j) == null) continue;
                d += this.widths.get(j) * this.heights.get(i);
            }
        }
        return d / (this.twidth * this.theight);
    }

    public double getWidth() {
        return this.twidth;
    }

    public double getHeight() {
        return this.theight;
    }

    public Set<Map.Entry<T, double[]>> entrySet() {
        return Collections.unmodifiableSet(this.map.entrySet());
    }

    public Set<T> keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public static void main(String[] stringArray) {
        LoggingConfiguration.setLevelFor(RectangleArranger.class.getName(), Level.FINEST.getName());
        RectangleArranger<String> rectangleArranger = new RectangleArranger<String>(1.3);
        rectangleArranger.put(4.0, 1.0, "Histogram");
        rectangleArranger.put(4.0, 4.0, "3D view");
        rectangleArranger.put(1.0, 1.0, "Meta 1");
        rectangleArranger.put(1.0, 1.0, "Meta 2");
        rectangleArranger.put(1.0, 1.0, "Meta 3");
        rectangleArranger.put(2.0, 2.0, "Meta 4");
        rectangleArranger.put(2.0, 2.0, "Meta 5");
        rectangleArranger = new RectangleArranger(3.0, 3.0);
        rectangleArranger.put(1.0, 2.0, "A");
        rectangleArranger.put(2.0, 1.0, "B");
        rectangleArranger.put(1.0, 2.0, "C");
        rectangleArranger.put(2.0, 1.0, "D");
        rectangleArranger.put(2.0, 2.0, "E");
        rectangleArranger = new RectangleArranger(1.3478260869565215);
        rectangleArranger.put(4.0, 0.5, "A");
        rectangleArranger.put(4.0, 3.0, "B");
        rectangleArranger.put(4.0, 1.0, "C");
        rectangleArranger.put(1.0, 0.1, "D");
    }
}

