/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.projections;

import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import de.lmu.ifi.dbs.elki.math.scales.LinearScale;
import de.lmu.ifi.dbs.elki.visualization.projections.AbstractFullProjection;
import de.lmu.ifi.dbs.elki.visualization.projector.Projector;

public abstract class AbstractSimpleProjection
extends AbstractFullProjection {
    public AbstractSimpleProjection(Projector projector, LinearScale[] linearScaleArray) {
        super(projector, linearScaleArray);
    }

    @Override
    public double[] projectScaledToRender(double[] dArray) {
        dArray = this.rearrange(dArray);
        VMath.minusEquals(dArray, 0.5);
        dArray = this.flipSecondEquals(dArray);
        VMath.timesEquals(dArray, 100.0);
        return dArray;
    }

    @Override
    public double[] projectRenderToScaled(double[] dArray) {
        dArray = VMath.times(dArray, 0.01);
        dArray = this.flipSecondEquals(dArray);
        VMath.plusEquals(dArray, 0.5);
        dArray = this.dearrange(dArray);
        return dArray;
    }

    @Override
    public double[] projectRelativeScaledToRender(double[] dArray) {
        dArray = this.rearrange(dArray);
        dArray = this.flipSecondEquals(dArray);
        VMath.timesEquals(dArray, 100.0);
        return dArray;
    }

    @Override
    public double[] projectRelativeRenderToScaled(double[] dArray) {
        dArray = VMath.times(dArray, 0.01);
        dArray = this.flipSecondEquals(dArray);
        dArray = this.dearrange(dArray);
        return dArray;
    }

    protected double[] flipSecondEquals(double[] dArray) {
        if (dArray.length > 1) {
            dArray[1] = dArray[1] * -1.0;
        }
        return dArray;
    }

    protected abstract double[] rearrange(double[] var1);

    protected abstract double[] dearrange(double[] var1);
}

