/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.projections;

public class CanvasSize {
    public final double minx;
    public final double maxx;
    public final double miny;
    public final double maxy;

    public CanvasSize(double d, double d2, double d3, double d4) {
        this.minx = d;
        this.maxx = d2;
        this.miny = d3;
        this.maxy = d4;
    }

    public double getMinX() {
        return this.minx;
    }

    public double getMaxX() {
        return this.maxx;
    }

    public double getMinY() {
        return this.miny;
    }

    public double getMaxY() {
        return this.maxy;
    }

    public double getDiffX() {
        return this.maxx - this.minx;
    }

    public double getDiffY() {
        return this.maxy - this.miny;
    }

    public double continueToMargin(double[] dArray, double[] dArray2) {
        assert (dArray2.length == 2 && dArray.length == 2);
        double d = Double.POSITIVE_INFINITY;
        if (dArray2[0] > 0.0) {
            d = Math.min(d, (this.maxx - dArray[0]) / dArray2[0]);
        } else if (dArray2[0] < 0.0) {
            d = Math.min(d, (dArray[0] - this.minx) / -dArray2[0]);
        }
        if (dArray2[1] > 0.0) {
            d = Math.min(d, (this.maxy - dArray[1]) / dArray2[1]);
        } else if (dArray2[1] < 0.0) {
            d = Math.min(d, (dArray[1] - this.miny) / -dArray2[1]);
        }
        return d;
    }

    public String toString() {
        return "CanvasSize[x=" + this.minx + ":" + this.maxx + ", y=" + this.miny + ":" + this.maxy + "]";
    }
}

