/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.projector;

import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.FilteredIter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.projector.ParallelPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.projector.ProjectorFactory;

public class ParallelPlotFactory
implements ProjectorFactory {
    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        Hierarchy.Iter<Relation> iter = VisualizationTree.filterResults(visualizerContext, object, Relation.class);
        while (iter.valid()) {
            block4: {
                Relation relation = iter.get();
                int n = this.dimensionality(relation);
                if (n > 1) {
                    Relation relation2;
                    FilteredIter<Relation> filteredIter = new FilteredIter<Relation>(visualizerContext.getHierarchy().iterAncestors(relation), Relation.class);
                    while (filteredIter.valid()) {
                        relation2 = (Relation)filteredIter.get();
                        int n2 = this.dimensionality(relation2);
                        if (n2 != n) {
                            filteredIter.advance();
                            continue;
                        }
                        break block4;
                    }
                    relation2 = relation;
                    ParallelPlotProjector parallelPlotProjector = new ParallelPlotProjector(relation2);
                    visualizerContext.addVis(relation2, parallelPlotProjector);
                }
            }
            iter.advance();
        }
    }

    private int dimensionality(Relation<?> relation) {
        if (TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(relation.getDataTypeInformation())) {
            Relation<?> relation2 = relation;
            return RelationUtil.dimensionality(relation2);
        }
        if (TypeUtil.UNCERTAIN_OBJECT_FIELD.isAssignableFromType(relation.getDataTypeInformation())) {
            Relation<?> relation3 = relation;
            return RelationUtil.dimensionality(relation3);
        }
        return 0;
    }
}

