/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.svg;

import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import java.text.NumberFormat;
import org.w3c.dom.Element;

public class SVGScoreBar {
    protected double val;
    protected double min = 0.0;
    protected double max = 1.0;
    protected boolean reversed = false;
    protected String label = null;
    private NumberFormat format = null;

    public void setFill(double d, double d2, double d3) {
        this.val = d;
        this.min = d2;
        this.max = d3;
    }

    public void setReversed(boolean bl) {
        this.reversed = bl;
    }

    public void addLabel(String string) {
        this.label = string;
    }

    public void showValues(NumberFormat numberFormat) {
        this.format = numberFormat;
    }

    public Element build(SVGPlot sVGPlot, double d, double d2, double d3, double d4) {
        Element element = sVGPlot.svgElement("g");
        Element element2 = sVGPlot.svgRect(d, d2, d3, d4);
        element2.setAttribute("fill", "#a0a0a0");
        element2.setAttribute("stroke", "#a0a0a0");
        element2.setAttribute("stroke-width", String.valueOf(d4 * 0.01));
        element.appendChild(element2);
        if (this.val >= this.min && this.val <= this.max && this.min < this.max) {
            double d5 = 0.02 * d4;
            double d6 = (this.val - this.min) / (this.max - this.min) * (d3 - 2.0 * d5);
            Element element3 = this.reversed ? sVGPlot.svgRect(d + d5 + d6, d2 + d5, d3 - d6 - 2.0 * d5, d4 - 2.0 * d5) : sVGPlot.svgRect(d + d5, d2 + d5, d6, d4 - 2.0 * d5);
            element3.setAttribute("fill", "#d4e4f1");
            element3.setAttribute("stroke", "#a0a0a0");
            element3.setAttribute("stroke-width", String.valueOf(d4 * 0.01));
            element.appendChild(element3);
        }
        if (this.format != null) {
            String string = Double.isNaN(this.val) ? "NaN" : this.format.format(this.val);
            Element element4 = sVGPlot.svgText(d + 0.05 * d3, d2 + 0.75 * d4, string);
            element4.setAttribute("style", "font-size: " + 0.75 * d4 + "; font-weight: bold");
            element.appendChild(element4);
        }
        if (this.label != null) {
            Element element5 = sVGPlot.svgText(d + 1.05 * d3, d2 + 0.75 * d4, this.label);
            element5.setAttribute("style", "font-size: " + 0.75 * d4 + "; font-weight: normal");
            element.appendChild(element5);
        }
        return element;
    }
}

