/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.svg;

import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPath;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.awt.Color;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.text.html.StyleSheet;
import org.apache.batik.dom.events.DOMMouseEvent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGLocatable;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGPoint;

public final class SVGUtil {
    public static final NumberFormat FMT = NumberFormat.getInstance(Locale.ROOT);
    public static final String HOURGLASS_PATH = "M.35 .2 L.65 .2 L.65 .3 L.35 .7 L.35 .8 L.65 .8 L.65 .7 L.35 .3 Z";
    public static final String HOURGLASS_STYLE = "stroke: black; stroke-width: .01; fill: grey; opacity: .2";
    public static final String THROBBER_PATH = "M.5,.25 a.25,.25 0 0 1 .1766,.42635 l-.0589 -.0589 a-.1766 -.1766 0 0 0 -.1178,-.2835 z";
    public static final String THROBBER_STYLE = "fill: #3d7fe6; opacity: .2";
    private static final TObjectIntHashMap<String> SVG_COLOR_NAMES;
    private static final int NO_VALUE = 1193046;
    private static final StyleSheet colorLookupStylesheet;

    public static String fmt(double d) {
        return FMT.format(d);
    }

    public static Element svgElement(Document document, String string) {
        return document.createElementNS("http://www.w3.org/2000/svg", string);
    }

    public static void setAtt(Element element, String string, double d) {
        element.setAttribute(string, SVGUtil.fmt(d));
    }

    public static void setAtt(Element element, String string, int n) {
        element.setAttribute(string, Integer.toString(n));
    }

    public static void setAtt(Element element, String string, String string2) {
        element.setAttribute(string, string2);
    }

    public static void setStyle(Element element, String string) {
        element.setAttribute("style", string);
    }

    public static void setCSSClass(Element element, String string) {
        SVGUtil.setAtt(element, "class", string);
    }

    public static void addCSSClass(Element element, String string) {
        String[] stringArray;
        String string2 = element.getAttribute("class");
        if (string2 == null || string2.length() == 0) {
            SVGUtil.setAtt(element, "class", string);
            return;
        }
        for (String string3 : stringArray = string2.split(" ")) {
            if (!string3.equals(string)) continue;
            return;
        }
        SVGUtil.setAtt(element, "class", string2 + " " + string);
    }

    public static void removeCSSClass(Element element, String string) {
        String string2 = element.getAttribute("class");
        if (string2 == null) {
            return;
        }
        String[] stringArray = string2.split(" ");
        if (stringArray.length == 1) {
            if (string.equals(stringArray[0])) {
                element.removeAttribute("class");
            }
        } else if (stringArray.length == 2) {
            if (string.equals(stringArray[0])) {
                if (string.equals(stringArray[1])) {
                    element.removeAttribute("class");
                } else {
                    element.setAttribute("class", stringArray[1]);
                }
            } else if (string.equals(stringArray[1])) {
                element.setAttribute("class", stringArray[0]);
            }
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string3 : stringArray) {
                if (string3.equals(string)) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(string3);
            }
            element.setAttribute("class", stringBuilder.toString());
        }
    }

    public static Element makeStyleElement(Document document) {
        Element element = SVGUtil.svgElement(document, "style");
        element.setAttribute("type", "text/css");
        return element;
    }

    public static Element svgRect(Document document, double d, double d2, double d3, double d4) {
        Element element = SVGUtil.svgElement(document, "rect");
        SVGUtil.setAtt(element, "x", d);
        SVGUtil.setAtt(element, "y", d2);
        SVGUtil.setAtt(element, "width", d3);
        SVGUtil.setAtt(element, "height", d4);
        return element;
    }

    public static Element svgCircle(Document document, double d, double d2, double d3) {
        Element element = SVGUtil.svgElement(document, "circle");
        SVGUtil.setAtt(element, "cx", d);
        SVGUtil.setAtt(element, "cy", d2);
        SVGUtil.setAtt(element, "r", d3);
        return element;
    }

    public static Element svgLine(Document document, double d, double d2, double d3, double d4) {
        Element element = SVGUtil.svgElement(document, "line");
        SVGUtil.setAtt(element, "x1", d);
        SVGUtil.setAtt(element, "y1", d2);
        SVGUtil.setAtt(element, "x2", d3);
        SVGUtil.setAtt(element, "y2", d4);
        return element;
    }

    public static Element svgText(Document document, double d, double d2, String string) {
        Element element = SVGUtil.svgElement(document, "text");
        SVGUtil.setAtt(element, "x", d);
        SVGUtil.setAtt(element, "y", d2);
        element.setTextContent(string);
        return element;
    }

    public static Element svgWaitIcon(Document document, double d, double d2, double d3, double d4) {
        Element element = SVGUtil.svgElement(document, "g");
        SVGUtil.setAtt(element, "transform", "translate(" + d + " " + d2 + ") scale(" + d3 + " " + d4 + ")");
        Element element2 = SVGUtil.svgElement(document, "path");
        SVGUtil.setAtt(element2, "d", THROBBER_PATH);
        SVGUtil.setStyle(element2, THROBBER_STYLE);
        Element element3 = SVGUtil.svgElement(document, "animateTransform");
        SVGUtil.setAtt(element3, "attributeName", "transform");
        SVGUtil.setAtt(element3, "attributeType", "XML");
        SVGUtil.setAtt(element3, "type", "rotate");
        SVGUtil.setAtt(element3, "from", "0 .5 .5");
        SVGUtil.setAtt(element3, "to", "360 .5 .5");
        SVGUtil.setAtt(element3, "begin", SVGUtil.fmt(Math.random() * 2.0) + "s");
        SVGUtil.setAtt(element3, "dur", "2s");
        SVGUtil.setAtt(element3, "repeatCount", "indefinite");
        SVGUtil.setAtt(element3, "fill", "freeze");
        element2.appendChild(element3);
        element.appendChild(element2);
        return element;
    }

    public static Color stringToColor(String string) {
        int n = SVG_COLOR_NAMES.get(string.toLowerCase());
        if (n != 1193046) {
            return new Color(n, false);
        }
        return colorLookupStylesheet.stringToColor(string);
    }

    public static String colorToString(Color color) {
        return SVGUtil.colorToString(color.getRGB());
    }

    public static String colorToString(int n) {
        char[] cArray = new char[]{'#', 'X', 'X', 'X', 'X', 'X', 'X'};
        for (int i = 6; i > 0; --i) {
            int n2 = n & 0xF;
            cArray[i] = (char)(n2 < 10 ? 48 + n2 : 97 + n2 - 10);
            n >>>= 4;
        }
        return new String(cArray);
    }

    public static String makeMarginTransform(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9 = d3 + d5 + d7;
        double d10 = d4 + d6 + d8;
        double d11 = Math.max(d9 / d, d10 / d2);
        double d12 = (d11 * d - d9) * 0.5 + d5;
        double d13 = (d11 * d2 - d10) * 0.5 + d6;
        return "scale(" + SVGUtil.fmt(1.0 / d11) + ") translate(" + SVGUtil.fmt(d12) + " " + SVGUtil.fmt(d13) + ")";
    }

    public static String makeMarginTransform(double d, double d2, double d3, double d4, double d5, double d6) {
        return SVGUtil.makeMarginTransform(d, d2, d3, d4, d5, d6, d5, d6);
    }

    public static String makeMarginTransform(double d, double d2, double d3, double d4, double d5) {
        return SVGUtil.makeMarginTransform(d, d2, d3, d4, d5, d5, d5, d5);
    }

    public static SVGPoint elementCoordinatesFromEvent(Document document, Element element, Event event) {
        try {
            DOMMouseEvent dOMMouseEvent = (DOMMouseEvent)event;
            SVGMatrix sVGMatrix = ((SVGLocatable)((Object)element)).getScreenCTM();
            SVGMatrix sVGMatrix2 = sVGMatrix.inverse();
            SVGPoint sVGPoint = ((SVGDocument)document).getRootElement().createSVGPoint();
            sVGPoint.setX(dOMMouseEvent.getClientX());
            sVGPoint.setY(dOMMouseEvent.getClientY());
            return sVGPoint.matrixTransform(sVGMatrix2);
        }
        catch (Exception exception) {
            LoggingUtil.warning("Error getting coordinates from SVG event.", exception);
            return null;
        }
    }

    public static void removeLastChild(Element element) {
        Node node = element.getLastChild();
        if (node != null) {
            element.removeChild(node);
        }
    }

    public static void removeFromParent(Element element) {
        if (element != null && element.getParentNode() != null) {
            element.getParentNode().removeChild(element);
        }
    }

    public static Element svgCircleSegment(SVGPlot sVGPlot, double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = Math.sin(d3);
        double d8 = MathUtil.sinToCos(d3, d7);
        double d9 = Math.sin(d3 + d4);
        double d10 = MathUtil.sinToCos(d3 + d4, d9);
        double d11 = d + d5 * d7;
        double d12 = d2 - d5 * d8;
        double d13 = d + d6 * d7;
        double d14 = d2 - d6 * d8;
        double d15 = d + d5 * d9;
        double d16 = d2 - d5 * d10;
        double d17 = d + d6 * d9;
        double d18 = d2 - d6 * d10;
        double d19 = 0.0;
        if (d4 >= Math.PI) {
            d19 = 1.0;
        }
        SVGPath sVGPath = new SVGPath(d11, d12);
        sVGPath.lineTo(d13, d14);
        sVGPath.ellipticalArc(d6, d6, 0.0, d19, 1.0, d17, d18);
        sVGPath.lineTo(d15, d16);
        if (d5 > 0.0) {
            sVGPath.ellipticalArc(d5, d5, 0.0, d19, 0.0, d11, d12);
        }
        return sVGPath.makeElement(sVGPlot);
    }

    static {
        FMT.setMaximumFractionDigits(10);
        FMT.setGroupingUsed(false);
        SVG_COLOR_NAMES = new TObjectIntHashMap(90, 0.8f, 1193046);
        SVG_COLOR_NAMES.put("aliceblue", -984833);
        SVG_COLOR_NAMES.put("antiquewhite", -332841);
        SVG_COLOR_NAMES.put("aqua", -16711681);
        SVG_COLOR_NAMES.put("aquamarine", -8388652);
        SVG_COLOR_NAMES.put("azure", -983041);
        SVG_COLOR_NAMES.put("beige", -657956);
        SVG_COLOR_NAMES.put("bisque", -6972);
        SVG_COLOR_NAMES.put("black", -16777216);
        SVG_COLOR_NAMES.put("blanchedalmond", -5171);
        SVG_COLOR_NAMES.put("blue", -16776961);
        SVG_COLOR_NAMES.put("blueviolet", -7722014);
        SVG_COLOR_NAMES.put("brown", -5952982);
        SVG_COLOR_NAMES.put("burlywood", -2180985);
        SVG_COLOR_NAMES.put("cadetblue", -10510688);
        SVG_COLOR_NAMES.put("chartreuse", -8388864);
        SVG_COLOR_NAMES.put("chocolate", -2987746);
        SVG_COLOR_NAMES.put("coral", -32944);
        SVG_COLOR_NAMES.put("cornflowerblue", -10185235);
        SVG_COLOR_NAMES.put("cornsilk", -1828);
        SVG_COLOR_NAMES.put("crimson", -2354116);
        SVG_COLOR_NAMES.put("cyan", -16711681);
        SVG_COLOR_NAMES.put("darkblue", -16777077);
        SVG_COLOR_NAMES.put("darkcyan", -16741493);
        SVG_COLOR_NAMES.put("darkgoldenrod", -4684277);
        SVG_COLOR_NAMES.put("darkgray", -5658199);
        SVG_COLOR_NAMES.put("darkgreen", -16751616);
        SVG_COLOR_NAMES.put("darkgrey", -5658199);
        SVG_COLOR_NAMES.put("darkkhaki", -4343957);
        SVG_COLOR_NAMES.put("darkmagenta", -7667573);
        SVG_COLOR_NAMES.put("darkolivegreen", -11179217);
        SVG_COLOR_NAMES.put("darkorange", -29696);
        SVG_COLOR_NAMES.put("darkorchid", -6737204);
        SVG_COLOR_NAMES.put("darkred", -7667712);
        SVG_COLOR_NAMES.put("darksalmon", -1468806);
        SVG_COLOR_NAMES.put("darkseagreen", -7357297);
        SVG_COLOR_NAMES.put("darkslateblue", -12042869);
        SVG_COLOR_NAMES.put("darkslategray", -13676721);
        SVG_COLOR_NAMES.put("darkslategrey", -13676721);
        SVG_COLOR_NAMES.put("darkturquoise", -16724271);
        SVG_COLOR_NAMES.put("darkviolet", -7077677);
        SVG_COLOR_NAMES.put("deeppink", -60269);
        SVG_COLOR_NAMES.put("deepskyblue", -16728065);
        SVG_COLOR_NAMES.put("dimgray", -9868951);
        SVG_COLOR_NAMES.put("dimgrey", -9868951);
        SVG_COLOR_NAMES.put("dodgerblue", -14774017);
        SVG_COLOR_NAMES.put("firebrick", -5103070);
        SVG_COLOR_NAMES.put("floralwhite", -1296);
        SVG_COLOR_NAMES.put("forestgreen", -14513374);
        SVG_COLOR_NAMES.put("fuchsia", -65281);
        SVG_COLOR_NAMES.put("gainsboro", -2302756);
        SVG_COLOR_NAMES.put("ghostwhite", -460545);
        SVG_COLOR_NAMES.put("gold", -10496);
        SVG_COLOR_NAMES.put("goldenrod", -2448096);
        SVG_COLOR_NAMES.put("gray", -8355712);
        SVG_COLOR_NAMES.put("grey", -8355712);
        SVG_COLOR_NAMES.put("green", -16744448);
        SVG_COLOR_NAMES.put("greenyellow", -5374161);
        SVG_COLOR_NAMES.put("honeydew", -983056);
        SVG_COLOR_NAMES.put("hotpink", -38476);
        SVG_COLOR_NAMES.put("indianred", -3318692);
        SVG_COLOR_NAMES.put("indigo", -11861886);
        SVG_COLOR_NAMES.put("ivory", -16);
        SVG_COLOR_NAMES.put("khaki", -989556);
        SVG_COLOR_NAMES.put("lavender", -1644806);
        SVG_COLOR_NAMES.put("lavenderblush", -3851);
        SVG_COLOR_NAMES.put("lawngreen", -8586240);
        SVG_COLOR_NAMES.put("lemonchiffon", -1331);
        SVG_COLOR_NAMES.put("lightblue", -5383962);
        SVG_COLOR_NAMES.put("lightcoral", -1015680);
        SVG_COLOR_NAMES.put("lightcyan", -2031617);
        SVG_COLOR_NAMES.put("lightgoldenrodyellow", -329006);
        SVG_COLOR_NAMES.put("lightgray", -2894893);
        SVG_COLOR_NAMES.put("lightgreen", -7278960);
        SVG_COLOR_NAMES.put("lightgrey", -2894893);
        SVG_COLOR_NAMES.put("lightpink", -18751);
        SVG_COLOR_NAMES.put("lightsalmon", -24454);
        SVG_COLOR_NAMES.put("lightseagreen", -14634326);
        SVG_COLOR_NAMES.put("lightskyblue", -7876870);
        SVG_COLOR_NAMES.put("lightslategray", -8943463);
        SVG_COLOR_NAMES.put("lightslategrey", -8943463);
        SVG_COLOR_NAMES.put("lightsteelblue", -5192482);
        SVG_COLOR_NAMES.put("lightyellow", -32);
        SVG_COLOR_NAMES.put("lime", -16711936);
        SVG_COLOR_NAMES.put("limegreen", -13447886);
        SVG_COLOR_NAMES.put("linen", -331546);
        SVG_COLOR_NAMES.put("magenta", -65281);
        SVG_COLOR_NAMES.put("maroon", -8388608);
        SVG_COLOR_NAMES.put("mediumaquamarine", -10039894);
        SVG_COLOR_NAMES.put("mediumblue", -16777011);
        SVG_COLOR_NAMES.put("mediumorchid", -4565549);
        SVG_COLOR_NAMES.put("mediumpurple", -7114533);
        SVG_COLOR_NAMES.put("mediumseagreen", -12799119);
        SVG_COLOR_NAMES.put("mediumslateblue", -8689426);
        SVG_COLOR_NAMES.put("mediumspringgreen", -16713062);
        SVG_COLOR_NAMES.put("mediumturquoise", -12004916);
        SVG_COLOR_NAMES.put("mediumvioletred", -3730043);
        SVG_COLOR_NAMES.put("midnightblue", -15132304);
        SVG_COLOR_NAMES.put("mintcream", -655366);
        SVG_COLOR_NAMES.put("mistyrose", -6943);
        SVG_COLOR_NAMES.put("moccasin", -6987);
        SVG_COLOR_NAMES.put("navajowhite", -8531);
        SVG_COLOR_NAMES.put("navy", -16777088);
        SVG_COLOR_NAMES.put("oldlace", -133658);
        SVG_COLOR_NAMES.put("olive", -8355840);
        SVG_COLOR_NAMES.put("olivedrab", -9728477);
        SVG_COLOR_NAMES.put("orange", -23296);
        SVG_COLOR_NAMES.put("orangered", -47872);
        SVG_COLOR_NAMES.put("orchid", -2461482);
        SVG_COLOR_NAMES.put("palegoldenrod", -1120086);
        SVG_COLOR_NAMES.put("palegreen", -6751336);
        SVG_COLOR_NAMES.put("paleturquoise", -5247250);
        SVG_COLOR_NAMES.put("palevioletred", -2396013);
        SVG_COLOR_NAMES.put("papayawhip", -4139);
        SVG_COLOR_NAMES.put("peachpuff", -9543);
        SVG_COLOR_NAMES.put("peru", -3308225);
        SVG_COLOR_NAMES.put("pink", -16181);
        SVG_COLOR_NAMES.put("plum", -2252579);
        SVG_COLOR_NAMES.put("powderblue", -5185306);
        SVG_COLOR_NAMES.put("purple", -8388480);
        SVG_COLOR_NAMES.put("red", -65536);
        SVG_COLOR_NAMES.put("rosybrown", -4419697);
        SVG_COLOR_NAMES.put("royalblue", -12490271);
        SVG_COLOR_NAMES.put("saddlebrown", -7650029);
        SVG_COLOR_NAMES.put("salmon", -360334);
        SVG_COLOR_NAMES.put("sandybrown", -744352);
        SVG_COLOR_NAMES.put("seagreen", -13726889);
        SVG_COLOR_NAMES.put("seashell", -2578);
        SVG_COLOR_NAMES.put("sienna", -6270419);
        SVG_COLOR_NAMES.put("silver", -4144960);
        SVG_COLOR_NAMES.put("skyblue", -7876885);
        SVG_COLOR_NAMES.put("slateblue", -9807155);
        SVG_COLOR_NAMES.put("slategray", -9404272);
        SVG_COLOR_NAMES.put("slategrey", -9404272);
        SVG_COLOR_NAMES.put("snow", -1286);
        SVG_COLOR_NAMES.put("springgreen", -16711809);
        SVG_COLOR_NAMES.put("steelblue", -12156236);
        SVG_COLOR_NAMES.put("tan", -2968436);
        SVG_COLOR_NAMES.put("teal", -16744320);
        SVG_COLOR_NAMES.put("thistle", -2572328);
        SVG_COLOR_NAMES.put("tomato", -40121);
        SVG_COLOR_NAMES.put("turquoise", -12525360);
        SVG_COLOR_NAMES.put("violet", -1146130);
        SVG_COLOR_NAMES.put("wheat", -663885);
        SVG_COLOR_NAMES.put("white", -1);
        SVG_COLOR_NAMES.put("whitesmoke", -657931);
        SVG_COLOR_NAMES.put("yellow", -256);
        SVG_COLOR_NAMES.put("yellowgreen", -6632142);
        SVG_COLOR_NAMES.put("transparent", -1);
        colorLookupStylesheet = new StyleSheet();
    }
}

