/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.optics;

import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.ClusterOrder;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.SetDBIDs;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.DBIDSelection;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.batikutil.DragableArea;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.OPTICSProjector;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.optics.AbstractOPTICSVisualization;
import org.apache.batik.dom.events.DOMMouseEvent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.svg.SVGPoint;

public class OPTICSPlotSelectionVisualization
extends AbstractVisFactory {
    private static final Logging LOG = Logging.getLogger(OPTICSPlotSelectionVisualization.class);
    private static final String NAME = "OPTICS Selection";

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        Hierarchy.Iter<OPTICSProjector> iter = VisualizationTree.filter(visualizerContext, object, OPTICSProjector.class);
        while (iter.valid()) {
            OPTICSProjector oPTICSProjector = iter.get();
            VisualizationTask visualizationTask = new VisualizationTask(NAME, visualizerContext, oPTICSProjector.getResult(), null, this);
            visualizationTask.level = 1000;
            visualizationTask.addUpdateFlags(2);
            visualizerContext.addVis(oPTICSProjector, visualizationTask);
            iter.advance();
        }
    }

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        return new Instance(visualizationTask, visualizationPlot, d, d2, projection);
    }

    @Override
    public boolean allowThumbnails(VisualizationTask visualizationTask) {
        return false;
    }

    public class Instance
    extends AbstractOPTICSVisualization
    implements DragableArea.DragListener {
        protected static final String CSS_MARKER = "opticsPlotMarker";
        protected static final String CSS_RANGEMARKER = "opticsPlotRangeMarker";
        private Element etag;
        private Element mtag;

        public Instance(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
            super(visualizationTask, visualizationPlot, d, d2, projection);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            this.makeLayerElement();
            this.addCSSClasses();
            this.mtag = this.svgp.svgElement("g");
            this.addMarker();
            DragableArea dragableArea = new DragableArea((SVGPlot)this.svgp, 0.0 - this.plotwidth * 0.1, 0.0, this.plotwidth * 1.1, this.plotheight, this);
            this.etag = dragableArea.getElement();
            this.layer.appendChild(this.mtag);
            this.layer.appendChild(this.etag);
        }

        public void addMarker() {
            ClusterOrder clusterOrder = this.getClusterOrder();
            DBIDSelection dBIDSelection = this.context.getSelection();
            if (dBIDSelection != null) {
                SetDBIDs setDBIDs = DBIDUtil.ensureSet(dBIDSelection.getSelectedIds());
                double d = this.plotwidth / (double)clusterOrder.size();
                int n = -1;
                int n2 = 0;
                Object object = clusterOrder.iter();
                while (object.valid()) {
                    if (setDBIDs.contains((DBIDRef)object)) {
                        if (n == -1) {
                            n = n2;
                        }
                    } else if (n != -1) {
                        Element element = this.addMarkerRect((double)n * d, (double)(n2 - n) * d);
                        SVGUtil.addCSSClass(element, CSS_MARKER);
                        this.mtag.appendChild(element);
                        n = -1;
                    }
                    object.advance();
                    ++n2;
                }
                if (n != -1) {
                    object = this.addMarkerRect((double)n * d, (double)(clusterOrder.size() - n) * d);
                    SVGUtil.addCSSClass((Element)object, CSS_MARKER);
                    this.mtag.appendChild((Node)object);
                }
            }
        }

        public Element addMarkerRect(double d, double d2) {
            return this.svgp.svgRect(d, 0.0, d2, this.plotheight);
        }

        @Override
        public boolean startDrag(SVGPoint sVGPoint, Event event) {
            ClusterOrder clusterOrder = this.getClusterOrder();
            int n = this.getSelectedIndex(clusterOrder, sVGPoint);
            if (n >= 0 && n < clusterOrder.size()) {
                double d = this.plotwidth / (double)clusterOrder.size();
                double d2 = (double)n * d;
                Element element = this.addMarkerRect(d2, d);
                SVGUtil.setCSSClass(element, CSS_RANGEMARKER);
                this.mtag.appendChild(element);
                return true;
            }
            return false;
        }

        @Override
        public boolean duringDrag(SVGPoint sVGPoint, SVGPoint sVGPoint2, Event event, boolean bl) {
            ClusterOrder clusterOrder = this.getClusterOrder();
            int n = this.getSelectedIndex(clusterOrder, sVGPoint);
            int n2 = this.getSelectedIndex(clusterOrder, sVGPoint2);
            int n3 = Math.max(Math.min(n, n2), 0);
            int n4 = Math.min(Math.max(n, n2), clusterOrder.size());
            double d = this.plotwidth / (double)clusterOrder.size();
            double d2 = (double)n3 * d;
            double d3 = (double)n4 * d + d;
            this.mtag.removeChild(this.mtag.getLastChild());
            Element element = this.addMarkerRect(d2, d3 - d2);
            SVGUtil.setCSSClass(element, CSS_RANGEMARKER);
            this.mtag.appendChild(element);
            return true;
        }

        @Override
        public boolean endDrag(SVGPoint sVGPoint, SVGPoint sVGPoint2, Event event, boolean bl) {
            ClusterOrder clusterOrder = this.getClusterOrder();
            int n = this.getSelectedIndex(clusterOrder, sVGPoint);
            int n2 = this.getSelectedIndex(clusterOrder, sVGPoint2);
            Mode mode = this.getInputMode(event);
            int n3 = Math.max(Math.min(n, n2), 0);
            int n4 = Math.min(Math.max(n, n2), clusterOrder.size());
            this.updateSelection(mode, n3, n4);
            return true;
        }

        private Mode getInputMode(Event event) {
            if (event instanceof DOMMouseEvent) {
                DOMMouseEvent dOMMouseEvent = (DOMMouseEvent)event;
                if (dOMMouseEvent.getShiftKey()) {
                    return Mode.ADD;
                }
                if (dOMMouseEvent.getCtrlKey()) {
                    return Mode.INVERT;
                }
                return Mode.REPLACE;
            }
            return Mode.REPLACE;
        }

        private int getSelectedIndex(ClusterOrder clusterOrder, SVGPoint sVGPoint) {
            int n = (int)((double)sVGPoint.getX() / this.plotwidth * (double)clusterOrder.size());
            return n;
        }

        protected void updateSelection(Mode mode, int n, int n2) {
            ClusterOrder clusterOrder = this.getClusterOrder();
            if (n < 0 || n > n2 || n2 >= clusterOrder.size()) {
                LOG.warning("Invalid range in updateSelection: " + n + " .. " + n2);
                return;
            }
            DBIDSelection dBIDSelection = this.context.getSelection();
            HashSetModifiableDBIDs hashSetModifiableDBIDs = dBIDSelection == null || mode == Mode.REPLACE ? DBIDUtil.newHashSet() : DBIDUtil.newHashSet(dBIDSelection.getSelectedIds());
            DBIDArrayIter dBIDArrayIter = clusterOrder.iter().seek(n);
            while (dBIDArrayIter.getOffset() <= n2) {
                if (mode == Mode.INVERT) {
                    if (!hashSetModifiableDBIDs.contains(dBIDArrayIter)) {
                        hashSetModifiableDBIDs.add(dBIDArrayIter);
                    } else {
                        hashSetModifiableDBIDs.remove(dBIDArrayIter);
                    }
                } else {
                    hashSetModifiableDBIDs.add(dBIDArrayIter);
                }
                dBIDArrayIter.advance();
            }
            this.context.setSelection(new DBIDSelection(hashSetModifiableDBIDs));
        }

        private void addCSSClasses() {
            CSSClass cSSClass;
            if (!this.svgp.getCSSClassManager().contains(CSS_MARKER)) {
                cSSClass = new CSSClass(this, CSS_MARKER);
                cSSClass.setStatement("fill", "blue");
                cSSClass.setStatement("opacity", "0.2");
                this.svgp.addCSSClassOrLogError(cSSClass);
            }
            if (!this.svgp.getCSSClassManager().contains(CSS_RANGEMARKER)) {
                cSSClass = new CSSClass(this, CSS_RANGEMARKER);
                cSSClass.setStatement("fill", "red");
                cSSClass.setStatement("opacity", "0.2");
                this.svgp.addCSSClassOrLogError(cSSClass);
            }
        }
    }

    private static enum Mode {
        REPLACE,
        ADD,
        INVERT;

    }
}

