/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.parallel.cluster;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.MeanModel;
import de.lmu.ifi.dbs.elki.data.model.MedoidModel;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreListener;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.utilities.exceptions.ObjectNotFoundException;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.colors.ColorLibrary;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ParallelPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.ClusterStylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.StylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPath;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.parallel.AbstractParallelVisualization;
import java.util.Iterator;
import org.w3c.dom.Element;

public class ClusterParallelMeanVisualization
extends AbstractVisFactory {
    private static final String NAME = "Cluster Means";

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        return new Instance(visualizationTask, visualizationPlot, d, d2, projection);
    }

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        Hierarchy.Iter<ParallelPlotProjector> iter = VisualizationTree.filter(visualizerContext, object, ParallelPlotProjector.class);
        while (iter.valid()) {
            ParallelPlotProjector parallelPlotProjector = iter.get();
            Relation relation = parallelPlotProjector.getRelation();
            if (TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(relation.getDataTypeInformation())) {
                VisualizationTask visualizationTask = new VisualizationTask(NAME, visualizerContext, parallelPlotProjector, parallelPlotProjector.getRelation(), this);
                visualizationTask.level = 101;
                visualizationTask.addUpdateFlags(5);
                visualizerContext.addVis(parallelPlotProjector, visualizationTask);
            }
            iter.advance();
        }
    }

    @Override
    public boolean allowThumbnails(VisualizationTask visualizationTask) {
        return false;
    }

    public class Instance
    extends AbstractParallelVisualization<NumberVector>
    implements DataStoreListener {
        public static final String CLUSTERMEAN = "Clustermean";

        public Instance(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
            super(visualizationTask, visualizationPlot, d, d2, projection);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            super.fullRedraw();
            StylingPolicy stylingPolicy = this.context.getStylingPolicy();
            if (!(stylingPolicy instanceof ClusterStylingPolicy)) {
                return;
            }
            Clustering<?> clustering = ((ClusterStylingPolicy)stylingPolicy).getClustering();
            if (clustering.getAllClusters().size() == 0) {
                return;
            }
            StyleLibrary styleLibrary = this.context.getStyleLibrary();
            ColorLibrary colorLibrary = styleLibrary.getColorSet("plot");
            Iterator<Cluster<?>> iterator = clustering.getAllClusters().iterator();
            for (int i = 0; i < clustering.getAllClusters().size(); ++i) {
                NumberVector numberVector;
                block8: {
                    Object obj = iterator.next().getModel();
                    numberVector = null;
                    try {
                        if (obj instanceof MeanModel) {
                            numberVector = ((MeanModel)obj).getMean();
                            break block8;
                        }
                        if (!(obj instanceof MedoidModel)) break block8;
                        numberVector = (NumberVector)this.relation.get(((MedoidModel)obj).getMedoid());
                    }
                    catch (ObjectNotFoundException objectNotFoundException) {
                        continue;
                    }
                }
                if (numberVector == null) continue;
                double[] dArray = this.proj.fastProjectDataToRenderSpace(numberVector);
                SVGPath sVGPath = new SVGPath();
                for (int j = 0; j < dArray.length; ++j) {
                    sVGPath.drawTo(this.getVisibleAxisX(j), dArray[j]);
                }
                Element element = sVGPath.makeElement(this.svgp);
                String string = CLUSTERMEAN + i;
                if (!this.svgp.getCSSClassManager().contains(string)) {
                    CSSClass cSSClass = new CSSClass(this, string);
                    cSSClass.setStatement("stroke-width", styleLibrary.getLineWidth("plot") * 2.0);
                    String string2 = colorLibrary.getColor(i);
                    cSSClass.setStatement("stroke", string2);
                    cSSClass.setStatement("fill", "none");
                    this.svgp.addCSSClassOrLogError(cSSClass);
                }
                SVGUtil.addCSSClass(element, string);
                this.layer.appendChild(element);
            }
        }
    }
}

