/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.parallel.selection;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreListener;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.result.DBIDSelection;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ParallelPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPath;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.parallel.AbstractParallelVisualization;
import org.w3c.dom.Element;

public class SelectionLineVisualization
extends AbstractVisFactory {
    public static final String NAME = "Selection Line";

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        return new Instance(visualizationTask, visualizationPlot, d, d2, projection);
    }

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        Hierarchy.Iter<ParallelPlotProjector> iter = VisualizationTree.filter(visualizerContext, object, ParallelPlotProjector.class);
        while (iter.valid()) {
            ParallelPlotProjector parallelPlotProjector = iter.get();
            Relation relation = parallelPlotProjector.getRelation();
            if (TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(relation.getDataTypeInformation())) {
                VisualizationTask visualizationTask = new VisualizationTask(NAME, visualizerContext, visualizerContext.getSelectionResult(), relation, this);
                visualizationTask.level = 99;
                visualizationTask.addUpdateFlags(3);
                visualizerContext.addVis(visualizerContext.getSelectionResult(), visualizationTask);
                visualizerContext.addVis(parallelPlotProjector, visualizationTask);
            }
            iter.advance();
        }
    }

    public class Instance
    extends AbstractParallelVisualization<NumberVector>
    implements DataStoreListener {
        public static final String MARKER = "SelectionLine";

        public Instance(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
            super(visualizationTask, visualizationPlot, d, d2, projection);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            super.fullRedraw();
            this.addCSSClasses(this.svgp);
            DBIDSelection dBIDSelection = this.context.getSelection();
            if (dBIDSelection != null) {
                DBIDs dBIDs = dBIDSelection.getSelectedIds();
                DBIDIter dBIDIter = dBIDs.iter();
                while (dBIDIter.valid()) {
                    Element element = this.drawLine(dBIDIter);
                    if (element != null) {
                        SVGUtil.addCSSClass(element, MARKER);
                        this.layer.appendChild(element);
                    }
                    dBIDIter.advance();
                }
            }
        }

        private Element drawLine(DBIDRef dBIDRef) {
            SVGPath sVGPath = new SVGPath();
            double[] dArray = this.proj.fastProjectDataToRenderSpace((NumberVector)this.relation.get(dBIDRef));
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            for (int i = 0; i < dArray.length; ++i) {
                if (dArray[i] != dArray[i]) {
                    bl = false;
                    bl2 = false;
                    continue;
                }
                if (bl) {
                    if (bl2) {
                        sVGPath.moveTo(this.getVisibleAxisX(i - 1), dArray[i - 1]);
                        bl2 = false;
                    }
                    sVGPath.lineTo(this.getVisibleAxisX(i), dArray[i]);
                    bl3 = true;
                } else {
                    bl2 = true;
                }
                bl = true;
            }
            if (!bl3) {
                return null;
            }
            return sVGPath.makeElement(this.svgp);
        }

        private void addCSSClasses(SVGPlot sVGPlot) {
            StyleLibrary styleLibrary = this.context.getStyleLibrary();
            if (!sVGPlot.getCSSClassManager().contains(MARKER)) {
                CSSClass cSSClass = new CSSClass(this, MARKER);
                cSSClass.setStatement("stroke", styleLibrary.getColor("plot.selection"));
                cSSClass.setStatement("stroke-opacity", styleLibrary.getOpacity("plot.selection"));
                cSSClass.setStatement("stroke-width", styleLibrary.getLineWidth("plot") * 2.0);
                cSSClass.setStatement("stroke-linecap", "round");
                cSSClass.setStatement("stroke-linejoin", "round");
                cSSClass.setStatement("fill", "none");
                sVGPlot.addCSSClassOrLogError(cSSClass);
            }
        }
    }
}

