/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.cluster;

import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.ClusterOrder;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreListener;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;
import org.w3c.dom.Element;

public class ClusterOrderVisualization
extends AbstractVisFactory {
    private static final String NAME = "Predecessor Graph";

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        return new Instance(visualizationTask, visualizationPlot, d, d2, projection);
    }

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        VisualizationTree.findNewSiblings(visualizerContext, object, ClusterOrder.class, ScatterPlotProjector.class, new VisualizationTree.Handler2<ClusterOrder, ScatterPlotProjector<?>>(){

            @Override
            public void process(VisualizerContext visualizerContext, ClusterOrder clusterOrder, ScatterPlotProjector<?> scatterPlotProjector) {
                Relation<?> relation = scatterPlotProjector.getRelation();
                if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(relation.getDataTypeInformation())) {
                    return;
                }
                VisualizationTask visualizationTask = new VisualizationTask(ClusterOrderVisualization.NAME, visualizerContext, clusterOrder, relation, ClusterOrderVisualization.this);
                visualizationTask.initDefaultVisibility(false);
                visualizationTask.level = 99;
                visualizationTask.addUpdateFlags(1);
                visualizerContext.addVis(clusterOrder, visualizationTask);
                visualizerContext.addVis(scatterPlotProjector, visualizationTask);
            }
        });
    }

    public class Instance
    extends AbstractScatterplotVisualization
    implements DataStoreListener {
        private static final String CSSNAME = "predecessor";
        protected ClusterOrder result;

        public Instance(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
            super(visualizationTask, visualizationPlot, d, d2, projection);
            this.result = (ClusterOrder)visualizationTask.getResult();
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            this.setupCanvas();
            StyleLibrary styleLibrary = this.context.getStyleLibrary();
            CSSClass cSSClass = new CSSClass(this, CSSNAME);
            styleLibrary.lines().formatCSSClass(cSSClass, 0, styleLibrary.getLineWidth("plot.clusterorder"), new Object[0]);
            this.svgp.addCSSClassOrLogError(cSSClass);
            DBIDVar dBIDVar = DBIDUtil.newVar();
            DBIDArrayIter dBIDArrayIter = this.result.iter();
            while (dBIDArrayIter.valid()) {
                this.result.getPredecessor(dBIDArrayIter, dBIDVar);
                if (!dBIDVar.isEmpty()) {
                    double[] dArray = this.proj.fastProjectDataToRenderSpace((NumberVector)this.rel.get(dBIDArrayIter));
                    double[] dArray2 = this.proj.fastProjectDataToRenderSpace((NumberVector)this.rel.get(dBIDVar));
                    if (dArray[0] == dArray[0] && dArray[1] == dArray[1] && dArray2[0] == dArray2[0] && dArray2[1] == dArray2[1]) {
                        Element element = this.svgp.svgLine(dArray2[0], dArray2[1], dArray[0], dArray[1]);
                        SVGUtil.setCSSClass(element, cSSClass.getName());
                        this.layer.appendChild(element);
                    }
                }
                dBIDArrayIter.advance();
            }
        }
    }
}

