/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.index;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreListener;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.LPNormDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.ManhattanDistanceFunction;
import de.lmu.ifi.dbs.elki.index.tree.AbstractNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTree;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.MTreeEntry;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.colors.ColorLibrary;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection2D;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGHyperSphere;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.index.TreeMBRVisualization;
import org.w3c.dom.Element;

public class TreeSphereVisualization
extends AbstractVisFactory {
    public static final String INDEX = "index";
    public static final String NAME = "Index Spheres";
    protected Parameterizer settings;

    public TreeSphereVisualization(Parameterizer parameterizer) {
        this.settings = parameterizer;
    }

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        VisualizationTree.findNewSiblings(visualizerContext, object, AbstractMTree.class, ScatterPlotProjector.class, new VisualizationTree.Handler2<AbstractMTree<?, ?, ?, ?>, ScatterPlotProjector<?>>(){

            @Override
            public void process(VisualizerContext visualizerContext, AbstractMTree<?, ?, ?, ?> abstractMTree, ScatterPlotProjector<?> scatterPlotProjector) {
                Relation<?> relation = scatterPlotProjector.getRelation();
                if (!TreeSphereVisualization.canVisualize(relation, abstractMTree)) {
                    return;
                }
                VisualizationTask visualizationTask = new VisualizationTask(TreeSphereVisualization.NAME, visualizerContext, abstractMTree, relation, TreeSphereVisualization.this);
                visualizationTask.level = 1;
                visualizationTask.initDefaultVisibility(false);
                visualizerContext.addVis(abstractMTree, visualizationTask);
                visualizerContext.addVis(scatterPlotProjector, visualizationTask);
            }
        });
    }

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        return new Instance(visualizationTask, visualizationPlot, d, d2, projection);
    }

    public static double getLPNormP(AbstractMTree<?, ?, ?, ?> abstractMTree) {
        DistanceFunction<?> distanceFunction = abstractMTree.getDistanceFunction();
        if (LPNormDistanceFunction.class.isInstance(distanceFunction)) {
            return ((LPNormDistanceFunction)distanceFunction).getP();
        }
        return 0.0;
    }

    public static boolean canVisualize(Relation<?> relation, AbstractMTree<?, ?, ?, ?> abstractMTree) {
        if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(relation.getDataTypeInformation())) {
            return false;
        }
        return TreeSphereVisualization.getLPNormP(abstractMTree) > 0.0;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        protected boolean fill = false;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            Flag flag = new Flag(TreeMBRVisualization.Parameterizer.FILL_ID);
            if (parameterization.grab(flag)) {
                this.fill = flag.isTrue();
            }
        }

        @Override
        protected TreeSphereVisualization makeInstance() {
            return new TreeSphereVisualization(this);
        }
    }

    public class Instance<N extends AbstractMTreeNode<?, N, E>, E extends MTreeEntry>
    extends AbstractScatterplotVisualization
    implements DataStoreListener {
        protected double p;
        protected Modus dist;
        protected AbstractMTree<?, N, E, ?> tree;

        public Instance(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
            super(visualizationTask, visualizationPlot, d, d2, projection);
            this.dist = Modus.LPCROSS;
            this.tree = (AbstractMTree)AbstractMTree.class.cast(visualizationTask.getResult());
            this.p = TreeSphereVisualization.getLPNormP(this.tree);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            this.setupCanvas();
            StyleLibrary styleLibrary = this.context.getStyleLibrary();
            int n = BitsUtil.cardinality(this.proj.getVisibleDimensions2D());
            ColorLibrary colorLibrary = styleLibrary.getColorSet("plot");
            this.p = TreeSphereVisualization.getLPNormP(this.tree);
            if (this.tree != null) {
                this.dist = ManhattanDistanceFunction.class.isInstance(this.tree.getDistanceFunction()) ? Modus.MANHATTAN : (EuclideanDistanceFunction.class.isInstance(this.tree.getDistanceFunction()) ? Modus.EUCLIDEAN : Modus.LPCROSS);
                MTreeEntry mTreeEntry = (MTreeEntry)this.tree.getRootEntry();
                int n2 = this.tree.getHeight();
                for (int i = 0; i < n2; ++i) {
                    CSSClass cSSClass = new CSSClass(this, TreeSphereVisualization.INDEX + i);
                    double d = 1.0 - (double)i / (double)n2;
                    if (TreeSphereVisualization.this.settings.fill) {
                        cSSClass.setStatement("stroke", colorLibrary.getColor(i));
                        cSSClass.setStatement("stroke-width", d * styleLibrary.getLineWidth("plot"));
                        cSSClass.setStatement("fill", colorLibrary.getColor(i));
                        cSSClass.setStatement("fill-opacity", 0.1 / (double)(n - 1));
                        cSSClass.setStatement("stroke-linecap", "round");
                        cSSClass.setStatement("stroke-linejoin", "round");
                    } else {
                        cSSClass.setStatement("stroke", colorLibrary.getColor(i));
                        cSSClass.setStatement("stroke-width", d * styleLibrary.getLineWidth("plot"));
                        cSSClass.setStatement("fill", "none");
                        cSSClass.setStatement("stroke-linecap", "round");
                        cSSClass.setStatement("stroke-linejoin", "round");
                    }
                    this.svgp.addCSSClassOrLogError(cSSClass);
                }
                this.visualizeMTreeEntry(this.svgp, this.layer, this.proj, this.tree, mTreeEntry, 0);
            }
        }

        private void visualizeMTreeEntry(SVGPlot sVGPlot, Element element, Projection2D projection2D, AbstractMTree<?, N, E, ?> abstractMTree, E e, int n) {
            Object object;
            DBID dBID = e.getRoutingObjectID();
            if (dBID != null) {
                object = (NumberVector)this.rel.get(dBID);
                double d = e.getCoveringRadius();
                Element element2 = this.dist == Modus.MANHATTAN ? SVGHyperSphere.drawManhattan(sVGPlot, projection2D, (NumberVector)object, d) : (this.dist == Modus.EUCLIDEAN ? SVGHyperSphere.drawEuclidean(sVGPlot, projection2D, (NumberVector)object, d) : SVGHyperSphere.drawLp(sVGPlot, projection2D, (NumberVector)object, d, this.p));
                SVGUtil.setCSSClass(element2, TreeSphereVisualization.INDEX + (n - 1));
                element.appendChild(element2);
            }
            if (!e.isLeafEntry()) {
                object = (AbstractMTreeNode)abstractMTree.getNode(e);
                for (int i = 0; i < ((AbstractNode)object).getNumEntries(); ++i) {
                    MTreeEntry mTreeEntry = (MTreeEntry)((AbstractNode)object).getEntry(i);
                    if (mTreeEntry.isLeafEntry()) continue;
                    this.visualizeMTreeEntry(sVGPlot, element, projection2D, abstractMTree, mTreeEntry, n + 1);
                }
            }
        }

        @Override
        public void destroy() {
            super.destroy();
            this.context.removeDataStoreListener(this);
        }
    }

    private static enum Modus {
        MANHATTAN,
        EUCLIDEAN,
        LPCROSS;

    }
}

