/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.selection;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreListener;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.result.DBIDSelection;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.utilities.exceptions.ObjectNotFoundException;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;
import org.w3c.dom.Element;

public class SelectionDotVisualization
extends AbstractVisFactory {
    private static final String NAME = "Selection Markers";

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        return new Instance(visualizationTask, visualizationPlot, d, d2, projection);
    }

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        Hierarchy.Iter<ScatterPlotProjector> iter = VisualizationTree.filter(visualizerContext, object, ScatterPlotProjector.class);
        while (iter.valid()) {
            ScatterPlotProjector scatterPlotProjector = iter.get();
            Relation relation = scatterPlotProjector.getRelation();
            if (TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(relation.getDataTypeInformation())) {
                VisualizationTask visualizationTask = new VisualizationTask(NAME, visualizerContext, visualizerContext.getSelectionResult(), relation, this);
                visualizationTask.level = 99;
                visualizationTask.addUpdateFlags(3);
                visualizerContext.addVis(visualizerContext.getSelectionResult(), visualizationTask);
                visualizerContext.addVis(scatterPlotProjector, visualizationTask);
            }
            iter.advance();
        }
    }

    public class Instance
    extends AbstractScatterplotVisualization
    implements DataStoreListener {
        public static final String MARKER = "selectionDotMarker";

        public Instance(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
            super(visualizationTask, visualizationPlot, d, d2, projection);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            this.setupCanvas();
            DBIDSelection dBIDSelection = this.context.getSelection();
            if (dBIDSelection == null) {
                return;
            }
            StyleLibrary styleLibrary = this.context.getStyleLibrary();
            if (!this.svgp.getCSSClassManager().contains(MARKER)) {
                CSSClass cSSClass = new CSSClass(this, MARKER);
                cSSClass.setStatement("fill", styleLibrary.getColor("plot.selection"));
                cSSClass.setStatement("opacity", styleLibrary.getOpacity("plot.selection"));
                this.svgp.addCSSClassOrLogError(cSSClass);
            }
            double d = styleLibrary.getSize("plot.selection");
            DBIDIter dBIDIter = dBIDSelection.getSelectedIds().iter();
            while (dBIDIter.valid()) {
                try {
                    double[] dArray = this.proj.fastProjectDataToRenderSpace((NumberVector)this.rel.get(dBIDIter));
                    if (dArray[0] == dArray[0] && dArray[1] == dArray[1]) {
                        Element element = this.svgp.svgCircle(dArray[0], dArray[1], d);
                        SVGUtil.addCSSClass(element, MARKER);
                        this.layer.appendChild(element);
                    }
                }
                catch (ObjectNotFoundException objectNotFoundException) {
                    // empty catch block
                }
                dBIDIter.advance();
            }
        }
    }
}

