/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.visunproj;

import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.evaluation.similaritymatrix.ComputeSimilarityMatrixImage;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.utilities.DatabaseUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import java.awt.image.RenderedImage;
import org.w3c.dom.Element;

public class SimilarityMatrixVisualizer
extends AbstractVisFactory {
    private static final String NAME = "Similarity Matrix Visualizer";

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        Hierarchy.Iter<ComputeSimilarityMatrixImage.SimilarityMatrix> iter = VisualizationTree.filterResults(visualizerContext, object, ComputeSimilarityMatrixImage.SimilarityMatrix.class);
        while (iter.valid()) {
            ComputeSimilarityMatrixImage.SimilarityMatrix similarityMatrix = iter.get();
            VisualizationTask visualizationTask = new VisualizationTask(NAME, visualizerContext, similarityMatrix, null, this);
            visualizationTask.reqwidth = 1.0;
            visualizationTask.reqheight = 1.0;
            visualizationTask.level = 200;
            visualizerContext.addVis(similarityMatrix, visualizationTask);
            iter.advance();
        }
    }

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        return new Instance(visualizationTask, visualizationPlot, d, d2);
    }

    @Override
    public boolean allowThumbnails(VisualizationTask visualizationTask) {
        return false;
    }

    public class Instance
    extends AbstractVisualization {
        private ComputeSimilarityMatrixImage.SimilarityMatrix result;

        public Instance(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2) {
            super(visualizationTask, visualizationPlot, d, d2);
            this.result = (ComputeSimilarityMatrixImage.SimilarityMatrix)visualizationTask.getResult();
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            StyleLibrary styleLibrary = this.context.getStyleLibrary();
            double d = 100.0 * this.getHeight() / this.getWidth();
            double d2 = styleLibrary.getSize("margin");
            this.layer = SVGUtil.svgElement(this.svgp.getDocument(), "g");
            String string = SVGUtil.makeMarginTransform(this.getWidth(), this.getHeight(), 100.0, d, d2);
            SVGUtil.setAtt(this.layer, "transform", string);
            RenderedImage renderedImage = this.result.getImage();
            double d3 = renderedImage.getHeight() / renderedImage.getWidth();
            double d4 = this.getHeight() / this.getWidth();
            double d5 = d3 >= d4 ? Math.min(d4 / d3, 1.0) : Math.max(d3 / d4, 1.0);
            Element element = this.svgp.svgElement("image");
            SVGUtil.setAtt(element, "image-rendering", "optimizeSpeed");
            SVGUtil.setAtt(element, "x", d2 * 0.75);
            SVGUtil.setAtt(element, "y", d2 * 0.75);
            SVGUtil.setAtt(element, "width", 100.0 * d5 * d3);
            SVGUtil.setAtt(element, "height", 100.0 * d5);
            element.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", this.result.getAsFile().toURI().toString());
            this.layer.appendChild(element);
            int n = this.result.getIDs().size();
            double d6 = 100.0 * d5 * d3 / (double)n;
            double d7 = 100.0 * d5 / (double)n;
            int n2 = 0;
            Database database = ResultUtil.findDatabase(this.context.getHierarchy());
            Relation<String> relation = DatabaseUtil.guessObjectLabelRepresentation(database);
            DBIDArrayIter dBIDArrayIter = this.result.getIDs().iter();
            while (dBIDArrayIter.valid()) {
                String string2 = relation.get(dBIDArrayIter);
                if (string2 != null) {
                    double d8 = d2 * 0.75 + d6 * ((double)n2 + 0.8);
                    double d9 = d2 * 0.7;
                    Element element2 = this.svgp.svgText(d8, d9, string2);
                    SVGUtil.setAtt(element2, "transform", "rotate(-90," + d8 + "," + d9 + ")");
                    SVGUtil.setAtt(element2, "style", "font-size: " + d6 * 0.8);
                    this.layer.appendChild(element2);
                    Element element3 = this.svgp.svgText(d2 * 0.7, d2 * 0.75 + d7 * ((double)n2 + 0.8), string2);
                    SVGUtil.setAtt(element3, "text-anchor", "end");
                    SVGUtil.setAtt(element3, "style", "font-size: " + d7 * 0.8);
                    this.layer.appendChild(element3);
                }
                ++n2;
                dBIDArrayIter.advance();
            }
        }
    }
}

