/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.distr.grid.wan;

import org.homedns.dade.jcgrid.message.GridMessageWorkRequest;
import org.jgap.distr.MasterInfo;
import org.jgap.distr.grid.gp.JGAPRequestGP;
import org.jgap.distr.grid.gp.JGAPResultGP;
import org.jgap.distr.grid.wan.ReceivedPacket;
import org.jgap.distr.grid.wan.RequestInformation;
import org.jgap.distr.grid.wan.ResultInformation;
import org.jgap.gp.IGPProgram;
import org.jgap.util.DateKit;
import org.jgap.util.NumberKit;

public class WANUtils {
    private static final String CVS_REVISION = "$Revision: 1.2 $";

    public static String outputRequestInformation(ReceivedPacket a_packet) {
        GridMessageWorkRequest greq = (GridMessageWorkRequest)a_packet.getData();
        JGAPRequestGP req = (JGAPRequestGP)greq.getWorkRequest();
        MasterInfo worker = req.getRequesterInfo();
        String postfix = req.getID();
        String descr = req.getDescription();
        if (descr != null && descr.length() > 0) {
            postfix = postfix + "(" + descr + ")";
        }
        int popSize = req.getConfiguration().getPopulationSize();
        String popSizeS = "pop:" + popSize;
        postfix = postfix + ", " + popSizeS;
        return WANUtils.outputInformation(worker, postfix);
    }

    public static String outputRequestInformation(RequestInformation a_info) {
        MasterInfo worker = a_info.requesterInfo;
        String postfix = a_info.getID();
        String descr = a_info.getDescription();
        if (descr != null && descr.length() > 0) {
            postfix = postfix + "(" + descr + ")";
        }
        String reqDate = a_info.getRequestDate() == null ? "unkn. date" : DateKit.dateToString(a_info.getRequestDate(), "yyyy/MM/dd HH:mm:ss:SSS");
        String title = a_info.getTitle();
        if (title == null) {
            title = "no title";
        }
        int popSize = a_info.getPopSize();
        String popSizeS = "pop:" + popSize;
        String s = worker.m_IPAddress + ":" + worker.m_name + " / " + postfix + " / " + title + " / " + reqDate + " / " + popSizeS;
        return s;
    }

    public static String outputResultInformation(ReceivedPacket a_packet) {
        long duration;
        JGAPResultGP res = (JGAPResultGP)((Object)a_packet.getData());
        MasterInfo worker = res.getWorkerInfo();
        String fitness = WANUtils.getFitnessString(res);
        String postfix = "";
        String descr = res.getDescription();
        if (descr != null && descr.length() > 0) {
            postfix = postfix + " (" + descr + ")";
        }
        String dur = (duration = res.getDurationComputation()) > 1L ? " / " + duration / 1000L + "sec." : "";
        return WANUtils.outputInformation(worker, res.getID()) + fitness + dur + postfix;
    }

    public static String outputResultInformation(ResultInformation a_info) {
        long duration;
        MasterInfo worker = a_info.workerInfo;
        String fitness = NumberKit.niceDecimalNumber(a_info.m_fittest, 2);
        String postfix = "";
        String respDate = a_info.getResponseDate() == null ? "unkn. date" : DateKit.dateToString(a_info.getResponseDate(), "yyyy/MM/dd HH:mm:ss:SSS");
        String descr = a_info.getDescription();
        if (descr != null && descr.length() > 0) {
            postfix = postfix + " (" + descr + ")";
        }
        String dur = (duration = a_info.getDurationComputation()) > 1L ? duration / 1000L + "sec." : "unkn. duration";
        String title = a_info.getTitle();
        if (title == null) {
            title = "no title";
        }
        String ID = a_info.getID();
        int popSize = a_info.getPopSize();
        String popSizeS = "pop:" + popSize;
        postfix = postfix + ", " + popSizeS;
        String s = worker.m_IPAddress + ":" + worker.m_name + " / " + ID + "/ " + fitness + " / " + title + " / " + respDate + " / " + popSizeS + " / " + dur + postfix;
        return s;
    }

    public static String getFitnessString(JGAPResultGP res) {
        String fitness = " / fitness: ";
        fitness = res.getFittest() != null ? fitness + res.getFittest().getFitnessValue() : (res.getPopulation() != null ? (res.getPopulation().getGPProgram(0) != null ? fitness + NumberKit.niceDecimalNumber(res.getPopulation().getGPProgram(0).getFitnessValue(), 2) : fitness + "N/A") : fitness + "N/A");
        return fitness;
    }

    public static String outputInformation(MasterInfo worker, String postFix) {
        String s = worker.m_IPAddress + ":" + worker.m_name + " / " + postFix;
        return s;
    }

    public static IGPProgram getFittest(JGAPResultGP a_res) {
        if (a_res == null) {
            return null;
        }
        if (a_res.getFittest() != null) {
            return a_res.getFittest();
        }
        if (a_res.getPopulation() == null) {
            return null;
        }
        return a_res.getPopulation().determineFittestProgram();
    }

    public static double getFitnessValue(IGPProgram a_prog) {
        if (a_prog == null) {
            return -1.0;
        }
        return a_prog.getFitnessValue();
    }
}

