/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.gp.function;

import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.jgap.InvalidConfigurationException;
import org.jgap.gp.CommandGene;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.ProgramChromosome;
import org.jgap.gp.terminal.Variable;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;

public class ForXLoop
extends CommandGene
implements ICloneable {
    private static final String CVS_REVISION = "$Revision: 1.12 $";
    private Class m_type;

    public ForXLoop(GPConfiguration a_conf, Class a_type) throws InvalidConfigurationException {
        super(a_conf, 1, CommandGene.VoidClass);
        this.m_type = a_type;
    }

    public String toString() {
        return "for(int i=0;i<X;i++) { &1 }";
    }

    public String getName() {
        return "ForXLoop";
    }

    public void execute_void(ProgramChromosome c, int n, Object[] args) {
        int x;
        this.check(c);
        int index = c.getVariableWithReturnType(0, this.m_type);
        if (index < 0) {
            throw new IllegalStateException("Variable missing for forX");
        }
        Variable var = (Variable)c.getNode(index);
        if (this.m_type == CommandGene.IntegerClass) {
            x = (Integer)var.getValue();
        } else if (this.m_type == CommandGene.LongClass) {
            x = ((Long)var.getValue()).intValue();
        } else if (this.m_type == CommandGene.DoubleClass) {
            x = ((Double)var.getValue()).intValue();
        } else if (this.m_type == CommandGene.FloatClass) {
            x = ((Float)var.getValue()).intValue();
        } else {
            throw new RuntimeException("Type " + this.m_type + " unknown in ForXCommand");
        }
        if (x > 15) {
            x = 15;
        }
        for (int i = 0; i < x; ++i) {
            c.execute_void(n, 0, args);
        }
    }

    public boolean isValid(ProgramChromosome a_program) {
        return a_program.getVariableWithReturnType(0, this.m_type) >= 0;
    }

    public Class getChildType(IGPProgram a_ind, int a_chromNum) {
        return CommandGene.VoidClass;
    }

    public Class getReturnType() {
        return super.getReturnType();
    }

    public int compareTo(Object a_other) {
        int result = super.compareTo(a_other);
        if (result != 0) {
            return result;
        }
        ForXLoop other = (ForXLoop)a_other;
        return new CompareToBuilder().append((Object)this.m_type, (Object)other.m_type).toComparison();
    }

    public boolean equals(Object a_other) {
        try {
            ForXLoop other = (ForXLoop)a_other;
            return super.equals(a_other) && new EqualsBuilder().append((Object)this.m_type, (Object)other.m_type).append(this.size(), other.size()).isEquals();
        }
        catch (ClassCastException cex) {
            return false;
        }
    }

    public Object clone() {
        try {
            ForXLoop result = new ForXLoop(this.getGPConfiguration(), this.m_type);
            return result;
        }
        catch (Exception ex) {
            throw new CloneException(ex);
        }
    }
}

