/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.gp.function;

import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.jgap.InvalidConfigurationException;
import org.jgap.gp.CommandGene;
import org.jgap.gp.function.StoreTerminal;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.ProgramChromosome;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;

public class ReadTerminal
extends CommandGene
implements ICloneable {
    private static final String CVS_REVISION = "$Revision: 1.15 $";
    private String m_storageName;

    public ReadTerminal(GPConfiguration a_conf, Class a_returnType, String a_storageName) throws InvalidConfigurationException {
        this(a_conf, a_returnType, a_storageName, 0);
    }

    public ReadTerminal(GPConfiguration a_conf, Class a_returnType, String a_storageName, int a_subReturnType) throws InvalidConfigurationException {
        super(a_conf, 0, a_returnType, a_subReturnType, null);
        if (a_storageName == null || a_storageName.length() < 1) {
            throw new IllegalArgumentException("Memory name must not be empty!");
        }
        this.m_storageName = a_storageName;
    }

    public String toString() {
        return "read_from('" + this.m_storageName + "')";
    }

    public String getName() {
        return "Read Terminal";
    }

    public int execute_int(ProgramChromosome c, int n, Object[] args) {
        this.check(c);
        try {
            Integer value = (Integer)this.getGPConfiguration().readFromMemory(this.m_storageName);
            if (value == null) {
                return 0;
            }
            return value;
        }
        catch (IllegalArgumentException iex) {
            throw new IllegalStateException("ReadTerminal without preceeding StoreTerminal");
        }
    }

    public long execute_long(ProgramChromosome c, int n, Object[] args) {
        this.check(c);
        try {
            return (Long)this.getGPConfiguration().readFromMemory(this.m_storageName);
        }
        catch (IllegalArgumentException iex) {
            throw new IllegalStateException("ReadTerminal without preceeding StoreTerminal");
        }
    }

    public double execute_double(ProgramChromosome c, int n, Object[] args) {
        this.check(c);
        try {
            return (Double)this.getGPConfiguration().readFromMemory(this.m_storageName);
        }
        catch (IllegalArgumentException iex) {
            throw new IllegalStateException("ReadTerminal without preceeding StoreTerminal");
        }
    }

    public float execute_float(ProgramChromosome c, int n, Object[] args) {
        this.check(c);
        try {
            return ((Float)this.getGPConfiguration().readFromMemory(this.m_storageName)).floatValue();
        }
        catch (IllegalArgumentException iex) {
            throw new IllegalStateException("ReadTerminal without preceeding StoreTerminal");
        }
    }

    public Object execute_object(ProgramChromosome c, int n, Object[] args) {
        this.check(c);
        try {
            return this.getGPConfiguration().readFromMemory(this.m_storageName);
        }
        catch (IllegalArgumentException iex) {
            throw new IllegalStateException("ReadTerminal without preceeding StoreTerminal");
        }
    }

    public boolean isValid(ProgramChromosome a_program) {
        return a_program.getIndividual().getCommandOfClass(0, StoreTerminal.class) >= 0;
    }

    public int compareTo(Object a_other) {
        int result = super.compareTo(a_other);
        if (result != 0) {
            return result;
        }
        ReadTerminal other = (ReadTerminal)a_other;
        return new CompareToBuilder().append((Object)this.m_storageName, (Object)other.m_storageName).toComparison();
    }

    public boolean equals(Object a_other) {
        try {
            ReadTerminal other = (ReadTerminal)a_other;
            return super.equals(a_other) && new EqualsBuilder().append((Object)this.m_storageName, (Object)other.m_storageName).isEquals();
        }
        catch (ClassCastException cex) {
            return false;
        }
    }

    public Object clone() {
        try {
            ReadTerminal result = new ReadTerminal(this.getGPConfiguration(), this.getReturnType(), this.m_storageName, this.getSubReturnType());
            return result;
        }
        catch (Exception ex) {
            throw new CloneException(ex);
        }
    }
}

