/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.gp.impl;

import java.io.Serializable;
import java.util.Arrays;
import org.jgap.IBusinessKey;
import org.jgap.ICloneHandler;
import org.jgap.InvalidConfigurationException;
import org.jgap.gp.CommandGene;
import org.jgap.gp.GPProgramBase;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.function.ADF;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.GPProgramInfo;
import org.jgap.gp.impl.ProgramChromosome;
import org.jgap.gp.terminal.Argument;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;
import org.jgap.util.StringKit;

public class GPProgram
extends GPProgramBase
implements Serializable,
Comparable,
ICloneable,
IBusinessKey {
    private static final String CVS_REVISION = "$Revision: 1.24 $";
    static final String PROGRAMCHROM_DELIMITER_HEADING = "<";
    static final String PROGRAMCHROM_DELIMITER_CLOSING = ">";
    static final String PROGRAMCHROM_DELIMITER = "#";
    private ProgramChromosome[] m_chromosomes;

    public GPProgram() throws Exception {
    }

    public GPProgram(GPConfiguration a_conf, Class[] a_types, Class[][] a_argTypes, CommandGene[][] a_nodeSets, int[] a_minDepths, int[] a_maxDepths, int a_maxNodes) throws InvalidConfigurationException {
        super(a_conf);
        this.m_chromosomes = new ProgramChromosome[a_types.length];
        this.setTypes(a_types);
        this.setArgTypes(a_argTypes);
        this.setNodeSets(a_nodeSets);
        this.setMaxDepths(a_maxDepths);
        this.setMinDepths(a_minDepths);
        this.setMaxNodes(a_maxNodes);
    }

    public GPProgram(IGPProgram a_prog) throws InvalidConfigurationException {
        super(a_prog);
        this.m_chromosomes = new ProgramChromosome[this.getTypes().length];
    }

    public GPProgram(GPConfiguration a_conf, int a_numChromosomes) throws InvalidConfigurationException {
        super(a_conf);
        this.m_chromosomes = new ProgramChromosome[a_numChromosomes];
    }

    public ProgramChromosome getChromosome(int a_index) {
        IGPProgram ind = this.m_chromosomes[a_index].getIndividual();
        if (this != ind) {
            this.m_chromosomes[a_index].setIndividual(this);
        }
        return this.m_chromosomes[a_index];
    }

    public void setChromosome(int a_index, ProgramChromosome a_chrom) {
        this.m_chromosomes[a_index] = a_chrom;
    }

    public void growOrFull(int a_depth, boolean a_grow, int a_maxNodes, boolean[] a_fullModeAllowed, int a_tries) {
        GPConfiguration conf = this.getGPConfiguration();
        int size = this.m_chromosomes.length;
        for (int i = 0; i < size; ++i) {
            try {
                this.m_chromosomes[i] = new ProgramChromosome(conf, a_maxNodes, this);
            }
            catch (InvalidConfigurationException iex) {
                throw new RuntimeException(iex);
            }
            this.m_chromosomes[i].setArgTypes(this.getArgTypes()[i]);
            int len = this.getNodeSets()[i].length;
            for (int j = 0; j < len; ++j) {
                if (!(this.getNodeSets()[i][j] instanceof ADF)) continue;
                ((ADF)this.getNodeSets()[i][j]).setReturnType(this.getTypes()[((ADF)this.getNodeSets()[i][j]).getChromosomeNum()]);
            }
        }
        for (int i = 0; i < size; ++i) {
            int depth = this.getMaxDepths() != null && a_depth > this.getMaxDepths()[i] ? this.getMaxDepths()[i] : (this.getMinDepths() != null && a_depth < this.getMinDepths()[i] ? this.getMinDepths()[i] : a_depth);
            if (a_grow || a_fullModeAllowed == null || !a_fullModeAllowed[i]) {
                this.m_chromosomes[i].growOrFull(i, depth, this.getType(i), this.getArgType(i), this.getNodeSet(i), true, a_tries);
                continue;
            }
            this.m_chromosomes[i].growOrFull(i, depth, this.getType(i), this.getArgType(i), this.getNodeSet(i), false, a_tries);
        }
        if (this.getGPConfiguration().isUseProgramCache()) {
            GPProgramInfo pcInfo = this.getGPConfiguration().readProgramCache(this);
            if (pcInfo == null) {
                pcInfo = this.putToCache(this);
            } else {
                this.setFitnessValue(pcInfo.getFitnessValue());
            }
        }
    }

    protected GPProgramInfo putToCache(GPProgram a_program) {
        return this.getGPConfiguration().putToProgramCache(a_program);
    }

    public void growOrFull(Class[][] a_argTypes, CommandGene[][] a_nodeSets) {
        int i;
        int size = this.m_chromosomes.length;
        for (i = 0; i < size; ++i) {
            this.m_chromosomes[i].setArgTypes(a_argTypes[i]);
            int len = this.getNodeSets()[i].length;
            for (int j = 0; j < len; ++j) {
                if (!(this.getNodeSets()[i][j] instanceof ADF)) continue;
                ((ADF)this.getNodeSets()[i][j]).setReturnType(this.getTypes()[((ADF)this.getNodeSets()[i][j]).getChromosomeNum()]);
            }
        }
        for (i = 0; i < size; ++i) {
            ProgramChromosome chrom = this.m_chromosomes[i];
            chrom.setFunctionSet(a_nodeSets[i]);
            CommandGene[] functionSet = chrom.getFunctionSet();
            CommandGene[] newFktSet = new CommandGene[functionSet.length + a_argTypes[i].length];
            System.arraycopy(functionSet, 0, newFktSet, 0, functionSet.length);
            for (int ii = 0; ii < a_argTypes[i].length; ++ii) {
                try {
                    functionSet[a_nodeSets[i].length + ii] = new Argument(this.getGPConfiguration(), ii, a_argTypes[i][ii]);
                    continue;
                }
                catch (InvalidConfigurationException iex) {
                    throw new RuntimeException(iex);
                }
            }
            chrom.redepth();
        }
        if (this.getGPConfiguration().isUseProgramCache()) {
            GPProgramInfo pcInfo = this.getGPConfiguration().readProgramCache(this);
            if (pcInfo == null) {
                pcInfo = this.putToCache(this);
            } else {
                this.setFitnessValue(pcInfo.getFitnessValue());
            }
        }
    }

    public int size() {
        return this.m_chromosomes.length;
    }

    public String toString(int a_startNode) {
        if (a_startNode < 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.m_chromosomes.length; ++i) {
            if (i > 0) {
                sb.append(" ==> ");
            }
            sb.append(this.m_chromosomes[i].toString(a_startNode));
        }
        return sb.toString();
    }

    public String toStringNorm(int a_startNode) {
        if (a_startNode < 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.m_chromosomes.length; ++i) {
            if (i > 0) {
                sb.append(" ==> ");
            }
            this.m_chromosomes[i].setIndividual(this);
            sb.append(this.m_chromosomes[i].toStringNorm(a_startNode));
        }
        return sb.toString();
    }

    public String toStringDebug() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.m_chromosomes.length; ++i) {
            if (i > 0) {
                sb.append(" ==> ");
            }
            this.m_chromosomes[i].setIndividual(this);
            sb.append(this.m_chromosomes[i].toStringDebug());
        }
        return sb.toString();
    }

    public int execute_int(int a_chromosomeNum, Object[] a_args) {
        this.m_chromosomes[a_chromosomeNum].setIndividual(this);
        return this.m_chromosomes[a_chromosomeNum].execute_int(a_args);
    }

    public float execute_float(int a_chromosomeNum, Object[] a_args) {
        this.m_chromosomes[a_chromosomeNum].setIndividual(this);
        return this.m_chromosomes[a_chromosomeNum].execute_float(a_args);
    }

    public double execute_double(int a_chromosomeNum, Object[] a_args) {
        this.m_chromosomes[a_chromosomeNum].setIndividual(this);
        return this.m_chromosomes[a_chromosomeNum].execute_double(a_args);
    }

    public boolean execute_boolean(int a_chromosomeNum, Object[] a_args) {
        this.m_chromosomes[a_chromosomeNum].setIndividual(this);
        return this.m_chromosomes[a_chromosomeNum].execute_boolean(a_args);
    }

    public Object execute_object(int a_chromosomeNum, Object[] a_args) {
        this.m_chromosomes[a_chromosomeNum].setIndividual(this);
        return this.m_chromosomes[a_chromosomeNum].execute_object(a_args);
    }

    public void execute_void(int a_chromosomeNum, Object[] a_args) {
        this.m_chromosomes[a_chromosomeNum].setIndividual(this);
        this.m_chromosomes[a_chromosomeNum].execute_void(a_args);
    }

    public int getCommandOfClass(int a_chromosomeNum, Class a_class) {
        for (int i = a_chromosomeNum; i < this.m_chromosomes.length; ++i) {
            int j = this.m_chromosomes[i].getCommandOfClass(0, a_class);
            if (j < 0) continue;
            return j;
        }
        return -1;
    }

    public int compareTo(Object a_other) {
        if (a_other == null) {
            return 1;
        }
        int size = this.size();
        GPProgram other = (GPProgram)a_other;
        Object[] otherChroms = other.m_chromosomes;
        if (other.size() != size) {
            return this.size() - other.size();
        }
        Arrays.sort(this.m_chromosomes);
        Arrays.sort(otherChroms);
        for (int i = 0; i < size; ++i) {
            int comparison = this.m_chromosomes[i].compareTo(otherChroms[i]);
            if (comparison == 0) continue;
            return comparison;
        }
        return 0;
    }

    public Object clone() {
        try {
            int[] minDepthsClone = this.getMinDepths() != null ? (int[])this.getMinDepths().clone() : null;
            int[] maxDepthsClone = this.getMaxDepths() != null ? (int[])this.getMaxDepths().clone() : null;
            GPProgram result = new GPProgram(this.getGPConfiguration(), (Class[])this.getTypes().clone(), (Class[][])this.getArgTypes().clone(), (CommandGene[][])this.getNodeSets().clone(), minDepthsClone, maxDepthsClone, this.getMaxNodes());
            result.setFitnessValue(this.getFitnessValueDirectly());
            Object appData = this.getApplicationData();
            if (appData != null) {
                ICloneHandler cloner = this.getGPConfiguration().getJGAPFactory().getCloneHandlerFor(appData, null);
                if (cloner != null) {
                    result.setApplicationData(cloner.perform(appData, null, null));
                } else {
                    result.setApplicationData(appData);
                }
            }
            for (int i = 0; i < this.m_chromosomes.length && this.m_chromosomes[i] != null; ++i) {
                result.m_chromosomes[i] = (ProgramChromosome)this.m_chromosomes[i].clone();
            }
            return result;
        }
        catch (Exception ex) {
            throw new CloneException(ex);
        }
    }

    public String getPersistentRepresentation() {
        StringBuffer b = new StringBuffer();
        for (ProgramChromosome chrom : this.m_chromosomes) {
            b.append(PROGRAMCHROM_DELIMITER_HEADING);
            b.append(this.encode(chrom.getClass().getName() + PROGRAMCHROM_DELIMITER + chrom.getPersistentRepresentation()));
            b.append(PROGRAMCHROM_DELIMITER_CLOSING);
        }
        return b.toString();
    }

    protected String encode(String a_string) {
        return StringKit.encode(a_string);
    }

    protected String decode(String a_string) {
        return StringKit.decode(a_string);
    }

    public String getBusinessKey() {
        return this.toStringNorm(0);
    }
}

