/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import org.jgap.Configuration;
import org.jgap.Genotype;
import org.jgap.IChromosome;
import org.jgap.ICloneHandler;
import org.jgap.InvalidConfigurationException;
import org.jgap.NaturalSelector;
import org.jgap.NaturalSelectorExt;
import org.jgap.Population;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;

public class BestChromosomesSelector
extends NaturalSelectorExt
implements ICloneable {
    private static final String CVS_REVISION = "$Revision: 1.54 $";
    private Population m_chromosomes;
    private boolean m_needsSorting;
    private Comparator m_fitnessValueComparator;
    private BestChromosomesSelectorConfig m_config = new BestChromosomesSelectorConfig();

    public BestChromosomesSelector() throws InvalidConfigurationException {
        this(Genotype.getStaticConfiguration());
    }

    public BestChromosomesSelector(Configuration a_config) throws InvalidConfigurationException {
        this(a_config, 1.0);
    }

    public BestChromosomesSelector(Configuration a_config, double a_originalRate) throws InvalidConfigurationException {
        super(a_config);
        this.m_chromosomes = new Population(a_config);
        this.m_needsSorting = false;
        this.setDoubletteChromosomesAllowed(true);
        this.setOriginalRate(a_originalRate);
        this.m_fitnessValueComparator = new NaturalSelector.FitnessAgeValueComparator();
    }

    protected void add(IChromosome a_chromosomeToAdd) {
        if (!this.getDoubletteChromosomesAllowed() && this.m_chromosomes.getChromosomes().contains(a_chromosomeToAdd)) {
            return;
        }
        a_chromosomeToAdd.setIsSelectedForNextGeneration(false);
        if (this.getDoubletteChromosomesAllowed()) {
            ICloneHandler cloner = this.getConfiguration().getJGAPFactory().getCloneHandlerFor(a_chromosomeToAdd, null);
            if (cloner != null) {
                try {
                    IChromosome clone = (IChromosome)cloner.perform(a_chromosomeToAdd, null, null);
                    clone.setAge(a_chromosomeToAdd.getAge() + 1);
                    this.m_chromosomes.addChromosome(clone);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.m_chromosomes.addChromosome(a_chromosomeToAdd);
                }
            } else {
                this.m_chromosomes.addChromosome(a_chromosomeToAdd);
            }
        } else {
            this.m_chromosomes.addChromosome(a_chromosomeToAdd);
        }
        this.m_needsSorting = true;
    }

    public void selectChromosomes(int a_howManyToSelect, Population a_to_pop) {
        IChromosome selectedChromosome;
        int chromsSize = this.m_chromosomes.size();
        int canBeSelected = a_howManyToSelect > chromsSize ? chromsSize : a_howManyToSelect;
        int neededSize = a_howManyToSelect;
        double origRate = this.m_config.m_originalRate;
        if (origRate < 1.0 && (canBeSelected = (int)Math.round((double)canBeSelected * origRate)) < 1) {
            canBeSelected = 1;
        }
        if (this.m_needsSorting) {
            Collections.sort(this.m_chromosomes.getChromosomes(), this.m_fitnessValueComparator);
            this.m_needsSorting = false;
        }
        for (int i = 0; i < canBeSelected; ++i) {
            selectedChromosome = this.m_chromosomes.getChromosome(i);
            selectedChromosome.setIsSelectedForNextGeneration(true);
            a_to_pop.addChromosome(selectedChromosome);
        }
        if (this.getDoubletteChromosomesAllowed()) {
            int toAdd = neededSize - a_to_pop.size();
            for (int i = 0; i < toAdd; ++i) {
                selectedChromosome = this.m_chromosomes.getChromosome(i % chromsSize);
                ICloneHandler cloner = this.getConfiguration().getJGAPFactory().getCloneHandlerFor(selectedChromosome, null);
                IChromosome cloned = null;
                if (cloner != null) {
                    try {
                        int age = selectedChromosome.getAge() + 1;
                        cloned = (IChromosome)cloner.perform(selectedChromosome, null, null);
                        cloned.setAge(age);
                        cloned.setIsSelectedForNextGeneration(true);
                        if (this.m_monitorActive) {
                            cloned.setUniqueIDTemplate(selectedChromosome.getUniqueID(), 1);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (cloned != null) {
                    selectedChromosome = cloned;
                }
                a_to_pop.addChromosome(selectedChromosome);
            }
        }
    }

    public void empty() {
        this.m_chromosomes.getChromosomes().clear();
        this.m_needsSorting = false;
    }

    public boolean returnsUniqueChromosomes() {
        return true;
    }

    public void setOriginalRate(double a_originalRate) {
        if (a_originalRate < 0.0 || a_originalRate > 1.0) {
            throw new IllegalArgumentException("Original rate must be greater than zero and not greater than one!");
        }
        this.m_config.m_originalRate = a_originalRate;
    }

    public double getOriginalRate() {
        return this.m_config.m_originalRate;
    }

    public boolean equals(Object a_o) {
        if (a_o == null) {
            return false;
        }
        BestChromosomesSelector other = (BestChromosomesSelector)a_o;
        if (this.getDoubletteChromosomesAllowed() != other.getDoubletteChromosomesAllowed()) {
            return false;
        }
        if (!this.m_fitnessValueComparator.getClass().getName().equals(other.m_fitnessValueComparator.getClass().getName())) {
            return false;
        }
        if (Math.abs(this.m_config.m_originalRate - other.m_config.m_originalRate) > 0.001) {
            return false;
        }
        return this.m_chromosomes.equals(other.m_chromosomes);
    }

    public Object clone() {
        try {
            BestChromosomesSelector sel = new BestChromosomesSelector(this.getConfiguration(), this.m_config.m_originalRate);
            sel.m_needsSorting = this.m_needsSorting;
            sel.setDoubletteChromosomesAllowed(this.getDoubletteChromosomesAllowed());
            return sel;
        }
        catch (Throwable t) {
            throw new CloneException(t);
        }
    }

    class BestChromosomesSelectorConfig
    implements Serializable {
        public double m_originalRate;

        BestChromosomesSelectorConfig() {
        }
    }
}

