/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl;

import java.util.StringTokenizer;
import org.jgap.Configuration;
import org.jgap.Gene;
import org.jgap.Genotype;
import org.jgap.IPersistentRepresentation;
import org.jgap.InvalidConfigurationException;
import org.jgap.RandomGenerator;
import org.jgap.UnsupportedRepresentationException;
import org.jgap.impl.NumberGene;
import org.jgap.impl.StockRandomGenerator;

public class DoubleGene
extends NumberGene
implements IPersistentRepresentation {
    private static final String CVS_REVISION = "$Revision: 1.40 $";
    private double m_upperBound;
    private double m_lowerBound;

    public DoubleGene() throws InvalidConfigurationException {
        this(Genotype.getStaticConfiguration());
    }

    public DoubleGene(Configuration a_config) throws InvalidConfigurationException {
        this(a_config, -8.988465674311579E307, 8.988465674311579E307);
    }

    public DoubleGene(Configuration a_config, double a_lowerBound, double a_upperBound) throws InvalidConfigurationException {
        super(a_config);
        this.m_lowerBound = a_lowerBound;
        this.m_upperBound = a_upperBound;
    }

    protected Gene newGeneInternal() {
        try {
            DoubleGene result = new DoubleGene(this.getConfiguration(), this.m_lowerBound, this.m_upperBound);
            return result;
        }
        catch (InvalidConfigurationException iex) {
            throw new IllegalStateException(iex.getMessage());
        }
    }

    public String getPersistentRepresentation() {
        String s = this.getInternalValue() == null ? "null" : this.getInternalValue().toString();
        return s + ":" + this.m_lowerBound + ":" + this.m_upperBound;
    }

    public void setValueFromPersistentRepresentation(String a_representation) throws UnsupportedRepresentationException {
        if (a_representation != null) {
            StringTokenizer tokenizer = new StringTokenizer(a_representation, ":");
            if (tokenizer.countTokens() != 3) {
                throw new UnsupportedRepresentationException("The format of the given persistent representation  is not recognized: it does not contain three tokens: " + a_representation);
            }
            String valueRepresentation = tokenizer.nextToken();
            String lowerBoundRepresentation = tokenizer.nextToken();
            String upperBoundRepresentation = tokenizer.nextToken();
            if (valueRepresentation.equals("null")) {
                this.setAllele(null);
            } else {
                try {
                    this.setAllele(new Double(Double.parseDouble(valueRepresentation)));
                }
                catch (NumberFormatException e) {
                    throw new UnsupportedRepresentationException("The format of the given persistent representation is not recognized: field 1 does not appear to be a double value.");
                }
            }
            try {
                this.m_lowerBound = Double.parseDouble(lowerBoundRepresentation);
            }
            catch (NumberFormatException e) {
                throw new UnsupportedRepresentationException("The format of the given persistent representation is not recognized: field 2 does not appear to be a double value.");
            }
            try {
                this.m_upperBound = Double.parseDouble(upperBoundRepresentation);
            }
            catch (NumberFormatException e) {
                throw new UnsupportedRepresentationException("The format of the given persistent representation is not recognized: field 3 does not appear to be a double value.");
            }
        }
    }

    public double doubleValue() {
        return (Double)this.getAllele();
    }

    public void setToRandomValue(RandomGenerator a_numberGenerator) {
        this.setAllele(new Double((this.m_upperBound - this.m_lowerBound) * a_numberGenerator.nextDouble() + this.m_lowerBound));
    }

    protected int compareToNative(Object o1, Object o2) {
        return ((Double)o1).compareTo((Double)o2);
    }

    protected void mapValueToWithinBounds() {
        if (this.getAllele() != null) {
            Double d_value = (Double)this.getAllele();
            if (d_value.isInfinite()) {
                return;
            }
            if (d_value > this.m_upperBound || d_value < this.m_lowerBound) {
                RandomGenerator rn = this.getConfiguration() != null ? this.getConfiguration().getRandomGenerator() : new StockRandomGenerator();
                this.setAllele(new Double(rn.nextDouble() * (this.m_upperBound - this.m_lowerBound) + this.m_lowerBound));
            }
        }
    }

    public void applyMutation(int index, double a_percentage) {
        double range = (this.m_upperBound - this.m_lowerBound) * a_percentage;
        double newValue = this.doubleValue() + range;
        this.setAllele(new Double(newValue));
    }

    public int hashCode() {
        if (this.getInternalValue() == null) {
            return -3;
        }
        return super.hashCode();
    }

    public String toString() {
        String s = "DoubleGene(" + this.m_lowerBound + "," + this.m_upperBound + ")" + "=";
        s = this.getInternalValue() == null ? s + "null" : s + this.getInternalValue().toString();
        return s;
    }

    public double getLowerBound() {
        return this.m_lowerBound;
    }

    public double getUpperBound() {
        return this.m_upperBound;
    }
}

