/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import org.jgap.Configuration;
import org.jgap.Genotype;
import org.jgap.IChromosome;
import org.jgap.InvalidConfigurationException;
import org.jgap.NaturalSelectorExt;
import org.jgap.Population;
import org.jgap.RandomGenerator;

public class ThresholdSelector
extends NaturalSelectorExt {
    private static final String CVS_REVISION = "$Revision: 1.19 $";
    private List m_chromosomes;
    private boolean m_needsSorting;
    private FitnessValueComparator m_fitnessValueComparator;
    private ThresholdSelectorConfigurable m_config = new ThresholdSelectorConfigurable();

    public ThresholdSelector() throws InvalidConfigurationException {
        this(Genotype.getStaticConfiguration(), 0.3);
    }

    public ThresholdSelector(Configuration a_config, double a_bestChromosomes_Percentage) throws InvalidConfigurationException {
        super(a_config);
        if (a_bestChromosomes_Percentage < 0.0 || a_bestChromosomes_Percentage > 1.0) {
            throw new IllegalArgumentException("Percentage must be between 0.0 and 1.0 !");
        }
        this.m_config.m_bestChroms_Percentage = a_bestChromosomes_Percentage;
        this.m_chromosomes = new Vector();
        this.m_needsSorting = false;
        this.m_fitnessValueComparator = new FitnessValueComparator();
    }

    public void selectChromosomes(int a_howManyToSelect, Population a_to_pop) {
        int canBeSelected = a_howManyToSelect > this.m_chromosomes.size() ? this.m_chromosomes.size() : a_howManyToSelect;
        if (this.m_needsSorting) {
            Collections.sort(this.m_chromosomes, this.m_fitnessValueComparator);
            this.m_needsSorting = false;
        }
        int bestToBeSelected = (int)Math.round((double)canBeSelected * this.m_config.m_bestChroms_Percentage);
        for (int i = 0; i < bestToBeSelected; ++i) {
            a_to_pop.addChromosome((IChromosome)this.m_chromosomes.get(i));
        }
        int missing = a_howManyToSelect - bestToBeSelected;
        RandomGenerator rn = this.getConfiguration().getRandomGenerator();
        int size = this.m_chromosomes.size();
        for (int i = 0; i < missing; ++i) {
            int index = rn.nextInt(size);
            IChromosome chrom = (IChromosome)this.m_chromosomes.get(index);
            a_to_pop.addChromosome(chrom);
        }
    }

    public boolean returnsUniqueChromosomes() {
        return false;
    }

    public void empty() {
        this.m_chromosomes.clear();
        this.m_needsSorting = false;
    }

    protected void add(IChromosome a_chromosomeToAdd) {
        this.m_chromosomes.add(a_chromosomeToAdd);
        this.m_needsSorting = true;
    }

    class ThresholdSelectorConfigurable {
        public double m_bestChroms_Percentage;

        ThresholdSelectorConfigurable() {
        }
    }

    private class FitnessValueComparator
    implements Comparator {
        public int compare(Object a_first, Object a_second) {
            IChromosome chrom1 = (IChromosome)a_first;
            IChromosome chrom2 = (IChromosome)a_second;
            if (ThresholdSelector.this.getConfiguration().getFitnessEvaluator().isFitter(chrom2.getFitnessValue(), chrom1.getFitnessValue())) {
                return 1;
            }
            if (ThresholdSelector.this.getConfiguration().getFitnessEvaluator().isFitter(chrom1.getFitnessValue(), chrom2.getFitnessValue())) {
                return -1;
            }
            return 0;
        }
    }
}

