/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.point.impl;

import java.util.Comparator;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.point.Point;

public class PointDimensionComparator
implements Comparator<Point> {
    private int index;

    public PointDimensionComparator(int index) {
        if (index < 0) {
            throw new JMetalException("The index value is negative");
        }
        this.index = index;
    }

    @Override
    public int compare(Point pointOne, Point pointTwo) {
        if (pointOne == null) {
            throw new JMetalException("PointOne is null");
        }
        if (pointTwo == null) {
            throw new JMetalException("PointTwo is null");
        }
        if (this.index >= pointOne.getNumberOfDimensions()) {
            throw new JMetalException("The index value " + this.index + " is out of range (0,  " + (pointOne.getNumberOfDimensions() - 1) + ")");
        }
        if (this.index >= pointTwo.getNumberOfDimensions()) {
            throw new JMetalException("The index value " + this.index + " is out of range (0,  " + (pointTwo.getNumberOfDimensions() - 1) + ")");
        }
        if (pointOne.getDimensionValue(this.index) < pointTwo.getDimensionValue(this.index)) {
            return -1;
        }
        if (pointOne.getDimensionValue(this.index) > pointTwo.getDimensionValue(this.index)) {
            return 1;
        }
        return 0;
    }
}

