/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.archive.impl;

import java.util.Comparator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.SolutionListUtils;
import org.uma.jmetal.util.archive.impl.AbstractBoundedArchive;
import org.uma.jmetal.util.comparator.CrowdingDistanceComparator;
import org.uma.jmetal.util.solutionattribute.DensityEstimator;
import org.uma.jmetal.util.solutionattribute.impl.CrowdingDistance;

public class CrowdingDistanceArchive<S extends Solution<?>>
extends AbstractBoundedArchive<S> {
    private Comparator<S> crowdingDistanceComparator = new CrowdingDistanceComparator();
    private DensityEstimator<S> crowdingDistance = new CrowdingDistance();

    public CrowdingDistanceArchive(int maxSize) {
        super(maxSize);
    }

    @Override
    public void prune() {
        if (this.getSolutionList().size() > this.getMaxSize()) {
            this.crowdingDistance.computeDensityEstimator(this.getSolutionList());
            int index = new SolutionListUtils().findWorstSolution(this.getSolutionList(), this.crowdingDistanceComparator);
            this.getSolutionList().remove(index);
        }
    }

    public void computeDistance() {
        this.crowdingDistance.computeDensityEstimator(this.getSolutionList());
    }
}

