/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.gp.function;

import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.jgap.InvalidConfigurationException;
import org.jgap.gp.MathCommand;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.ProgramChromosome;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;

public class Increment
extends MathCommand
implements ICloneable {
    private static final String CVS_REVISION = "$Revision: 1.12 $";
    private int m_increment;

    public Increment(GPConfiguration a_conf, Class a_returnType) throws InvalidConfigurationException {
        this(a_conf, a_returnType, 1);
    }

    public Increment(GPConfiguration a_conf, Class a_returnType, int a_increment) throws InvalidConfigurationException {
        this(a_conf, a_returnType, a_increment, 0, 0);
    }

    public Increment(GPConfiguration a_conf, Class a_returnType, int a_increment, int a_subReturnType, int a_subChildType) throws InvalidConfigurationException {
        super(a_conf, 1, a_returnType, a_subReturnType, a_subChildType);
        this.m_increment = a_increment;
    }

    public String toString() {
        if (this.m_increment == 1) {
            return "INC(&1)";
        }
        return "INC(" + this.m_increment + ", &1)";
    }

    public String getName() {
        return "INC";
    }

    public int execute_int(ProgramChromosome c, int n, Object[] args) {
        return c.execute_int(n, 0, args) + this.m_increment;
    }

    public long execute_long(ProgramChromosome c, int n, Object[] args) {
        return c.execute_long(n, 0, args) + (long)this.m_increment;
    }

    public float execute_float(ProgramChromosome c, int n, Object[] args) {
        return c.execute_float(n, 0, args) + (float)this.m_increment;
    }

    public double execute_double(ProgramChromosome c, int n, Object[] args) {
        return c.execute_double(n, 0, args) + (double)this.m_increment;
    }

    public Object execute_object(ProgramChromosome c, int n, Object[] args) {
        return ((Compatible)c.execute_object(n, 0, args)).execute_increment();
    }

    public int compareTo(Object a_other) {
        int result = super.compareTo(a_other);
        if (result != 0) {
            return result;
        }
        Increment other = (Increment)a_other;
        return new CompareToBuilder().append(this.m_increment, other.m_increment).toComparison();
    }

    public boolean equals(Object a_other) {
        try {
            Increment other = (Increment)a_other;
            return super.equals(a_other) && new EqualsBuilder().append(this.m_increment, other.m_increment).isEquals();
        }
        catch (ClassCastException cex) {
            return false;
        }
    }

    public Object clone() {
        try {
            Increment result = new Increment(this.getGPConfiguration(), this.getReturnType());
            return result;
        }
        catch (Exception ex) {
            throw new CloneException(ex);
        }
    }

    protected static interface Compatible {
        public Object execute_increment();
    }
}

