/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.ht;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import weka.classifiers.trees.ht.LeafNode;
import weka.classifiers.trees.ht.SplitNode;
import weka.classifiers.trees.ht.WeightMass;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Utils;

public abstract class HNode
implements Serializable {
    private static final long serialVersionUID = 197233928177240264L;
    public Map<String, WeightMass> m_classDistribution = new LinkedHashMap<String, WeightMass>();
    protected int m_leafNum;
    protected int m_nodeNum;

    public HNode() {
    }

    public HNode(Map<String, WeightMass> classDistrib) {
        this.m_classDistribution = classDistrib;
    }

    public boolean isLeaf() {
        return true;
    }

    public int numEntriesInClassDistribution() {
        return this.m_classDistribution.size();
    }

    public boolean classDistributionIsPure() {
        int count = 0;
        for (Map.Entry<String, WeightMass> el : this.m_classDistribution.entrySet()) {
            if (el.getValue().m_weight > 0.0 && ++count > 1) break;
        }
        return count < 2;
    }

    public void updateDistribution(Instance inst) {
        if (inst.classIsMissing()) {
            return;
        }
        String classVal = inst.stringValue(inst.classAttribute());
        WeightMass m = this.m_classDistribution.get(classVal);
        if (m == null) {
            m = new WeightMass();
            m.m_weight = 1.0;
            this.m_classDistribution.put(classVal, m);
        }
        m.m_weight += inst.weight();
    }

    public double[] getDistribution(Instance inst, Attribute classAtt) throws Exception {
        double[] dist = new double[classAtt.numValues()];
        int i = 0;
        while (i < classAtt.numValues()) {
            WeightMass w = this.m_classDistribution.get(classAtt.value(i));
            dist[i] = w != null ? w.m_weight : 1.0;
            ++i;
        }
        Utils.normalize(dist);
        return dist;
    }

    public int installNodeNums(int nodeNum) {
        this.m_nodeNum = ++nodeNum;
        return nodeNum;
    }

    protected int dumpTree(int depth, int leafCount, StringBuffer buff) {
        double max = -1.0;
        String classVal = "";
        for (Map.Entry<String, WeightMass> e : this.m_classDistribution.entrySet()) {
            if (!(e.getValue().m_weight > max)) continue;
            max = e.getValue().m_weight;
            classVal = e.getKey();
        }
        buff.append(String.valueOf(classVal) + " (" + String.format("%-9.3f", max).trim() + ")");
        this.m_leafNum = ++leafCount;
        return leafCount;
    }

    protected void printLeafModels(StringBuffer buff) {
    }

    public void graphTree(StringBuffer text) {
        double max = -1.0;
        String classVal = "";
        for (Map.Entry<String, WeightMass> e : this.m_classDistribution.entrySet()) {
            if (!(e.getValue().m_weight > max)) continue;
            max = e.getValue().m_weight;
            classVal = e.getKey();
        }
        text.append("N" + this.m_nodeNum + " [label=\"" + classVal + " (" + String.format("%-9.3f", max).trim() + ")\" shape=box style=filled]\n");
    }

    public String toString(boolean printLeaf) {
        this.installNodeNums(0);
        StringBuffer buff = new StringBuffer();
        this.dumpTree(0, 0, buff);
        if (printLeaf) {
            buff.append("\n\n");
            this.printLeafModels(buff);
        }
        return buff.toString();
    }

    public double totalWeight() {
        double tw = 0.0;
        for (Map.Entry<String, WeightMass> e : this.m_classDistribution.entrySet()) {
            tw += e.getValue().m_weight;
        }
        return tw;
    }

    public LeafNode leafForInstance(Instance inst, SplitNode parent, String parentBranch) {
        return new LeafNode(this, parent, parentBranch);
    }

    public abstract void updateNode(Instance var1) throws Exception;
}

