/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.j48;

import weka.classifiers.trees.j48.Distribution;
import weka.classifiers.trees.j48.SplitCriterion;
import weka.core.ContingencyTables;

public abstract class EntropyBasedSplitCrit
extends SplitCriterion {
    private static final long serialVersionUID = -2618691439791653056L;

    public final double lnFunc(double num) {
        if (num < 1.0E-6) {
            return 0.0;
        }
        return ContingencyTables.lnFunc(num);
    }

    public final double oldEnt(Distribution bags) {
        double returnValue = 0.0;
        int j = 0;
        while (j < bags.numClasses()) {
            returnValue += this.lnFunc(bags.perClass(j));
            ++j;
        }
        return (this.lnFunc(bags.total()) - returnValue) / ContingencyTables.log2;
    }

    public final double newEnt(Distribution bags) {
        double returnValue = 0.0;
        int i = 0;
        while (i < bags.numBags()) {
            int j = 0;
            while (j < bags.numClasses()) {
                returnValue += this.lnFunc(bags.perClassPerBag(i, j));
                ++j;
            }
            returnValue -= this.lnFunc(bags.perBag(i));
            ++i;
        }
        return -(returnValue / ContingencyTables.log2);
    }

    public final double splitEnt(Distribution bags) {
        double returnValue = 0.0;
        int i = 0;
        while (i < bags.numBags()) {
            returnValue += this.lnFunc(bags.perBag(i));
            ++i;
        }
        return (this.lnFunc(bags.total()) - returnValue) / ContingencyTables.log2;
    }
}

