/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.RandomizableMultipleClassifiersCombiner;
import weka.classifiers.rules.ZeroR;
import weka.core.Aggregateable;
import weka.core.Capabilities;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class Vote
extends RandomizableMultipleClassifiersCombiner
implements TechnicalInformationHandler,
EnvironmentHandler,
Aggregateable<Classifier> {
    static final long serialVersionUID = -637891196294399624L;
    public static final int AVERAGE_RULE = 1;
    public static final int PRODUCT_RULE = 2;
    public static final int MAJORITY_VOTING_RULE = 3;
    public static final int MIN_RULE = 4;
    public static final int MAX_RULE = 5;
    public static final int MEDIAN_RULE = 6;
    public static final Tag[] TAGS_RULES = new Tag[]{new Tag(1, "AVG", "Average of Probabilities"), new Tag(2, "PROD", "Product of Probabilities"), new Tag(3, "MAJ", "Majority Voting"), new Tag(4, "MIN", "Minimum Probability"), new Tag(5, "MAX", "Maximum Probability"), new Tag(6, "MED", "Median")};
    protected int m_CombinationRule = 1;
    protected Random m_Random;
    protected List<String> m_classifiersToLoad = new ArrayList<String>();
    protected List<Classifier> m_preBuiltClassifiers = new ArrayList<Classifier>();
    protected transient Environment m_env = Environment.getSystemWide();
    protected Instances m_structure;

    public String globalInfo() {
        return "Class for combining classifiers. Different combinations of probability estimates for classification are available.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tFull path to serialized classifier to include.\n\tMay be specified multiple times to include\n\tmultiple serialized classifiers. Note: it does\n\tnot make sense to use pre-built classifiers in\n\ta cross-validation.", "P", 1, "-P <path to serialized classifier>"));
        result.addElement(new Option("\tThe combination rule to use\n\t(default: AVG)", "R", 1, "-R " + Tag.toOptionList(TAGS_RULES)));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        int i = 0;
        while (i < options.length) {
            result.add(options[i]);
            ++i;
        }
        result.add("-R");
        result.add("" + this.getCombinationRule());
        i = 0;
        while (i < this.m_classifiersToLoad.size()) {
            result.add("-P");
            result.add(this.m_classifiersToLoad.get(i));
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String loadString;
        String tmpStr = Utils.getOption('R', options);
        if (tmpStr.length() != 0) {
            this.setCombinationRule(new SelectedTag(tmpStr, TAGS_RULES));
        } else {
            this.setCombinationRule(new SelectedTag(1, TAGS_RULES));
        }
        this.m_classifiersToLoad.clear();
        while ((loadString = Utils.getOption('P', options)).length() != 0) {
            this.m_classifiersToLoad.add(loadString);
        }
        super.setOptions(options);
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.BOOK);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Ludmila I. Kuncheva");
        result.setValue(TechnicalInformation.Field.TITLE, "Combining Pattern Classifiers: Methods and Algorithms");
        result.setValue(TechnicalInformation.Field.YEAR, "2004");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "John Wiley and Sons, Inc.");
        TechnicalInformation additional = result.add(TechnicalInformation.Type.ARTICLE);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "J. Kittler and M. Hatef and Robert P.W. Duin and J. Matas");
        additional.setValue(TechnicalInformation.Field.YEAR, "1998");
        additional.setValue(TechnicalInformation.Field.TITLE, "On combining classifiers");
        additional.setValue(TechnicalInformation.Field.JOURNAL, "IEEE Transactions on Pattern Analysis and Machine Intelligence");
        additional.setValue(TechnicalInformation.Field.VOLUME, "20");
        additional.setValue(TechnicalInformation.Field.NUMBER, "3");
        additional.setValue(TechnicalInformation.Field.PAGES, "226-239");
        return result;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        if (this.m_preBuiltClassifiers.size() == 0 && this.m_classifiersToLoad.size() > 0) {
            try {
                this.loadClassifiers(null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.m_preBuiltClassifiers.size() > 0) {
            if (this.m_Classifiers.length == 0) {
                result = (Capabilities)this.m_preBuiltClassifiers.get(0).getCapabilities().clone();
            }
            int i = 1;
            while (i < this.m_preBuiltClassifiers.size()) {
                result.and(this.m_preBuiltClassifiers.get(i).getCapabilities());
                ++i;
            }
            Capabilities.Capability[] capabilityArray = Capabilities.Capability.values();
            int n = capabilityArray.length;
            int n2 = 0;
            while (n2 < n) {
                Capabilities.Capability cap = capabilityArray[n2];
                result.enableDependency(cap);
                ++n2;
            }
        }
        if (this.m_CombinationRule == 2 || this.m_CombinationRule == 3) {
            result.disableAllClasses();
            result.disableAllClassDependencies();
            result.enable(Capabilities.Capability.NOMINAL_CLASS);
            result.enableDependency(Capabilities.Capability.NOMINAL_CLASS);
        } else if (this.m_CombinationRule == 6) {
            result.disableAllClasses();
            result.disableAllClassDependencies();
            result.enable(Capabilities.Capability.NUMERIC_CLASS);
            result.enableDependency(Capabilities.Capability.NUMERIC_CLASS);
        }
        return result;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        Instances newData = new Instances(data);
        newData.deleteWithMissingClass();
        this.m_structure = new Instances(newData, 0);
        this.m_Random = new Random(this.getSeed());
        if (this.m_classifiersToLoad.size() > 0) {
            this.m_preBuiltClassifiers.clear();
            this.loadClassifiers(data);
            if (this.m_Classifiers.length == 1 && this.m_Classifiers[0] instanceof ZeroR) {
                this.m_Classifiers = new Classifier[0];
            }
        }
        this.getCapabilities().testWithFail(data);
        int i = 0;
        while (i < this.m_Classifiers.length) {
            this.getClassifier(i).buildClassifier(newData);
            ++i;
        }
    }

    private void loadClassifiers(Instances data) throws Exception {
        for (String path : this.m_classifiersToLoad) {
            File toLoad;
            if (Environment.containsEnvVariables(path)) {
                try {
                    path = this.m_env.substitute(path);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!(toLoad = new File(path)).isFile()) {
                throw new Exception("\"" + path + "\" does not seem to be a valid file!");
            }
            ObjectInputStream is = new ObjectInputStream(new BufferedInputStream(new FileInputStream(toLoad)));
            Object c = is.readObject();
            if (!(c instanceof Classifier)) {
                is.close();
                throw new Exception("\"" + path + "\" does not contain a classifier!");
            }
            Object header = null;
            header = is.readObject();
            if (header instanceof Instances && data != null && !data.equalHeaders((Instances)header)) {
                is.close();
                throw new Exception("\"" + path + "\" was trained with data that is " + "of a differnet structure than the incoming training data");
            }
            if (header == null) {
                System.out.println("[Vote] warning: no header instances for \"" + path + "\"");
            }
            is.close();
            this.addPreBuiltClassifier((Classifier)c);
        }
    }

    public void addPreBuiltClassifier(Classifier c) {
        this.m_preBuiltClassifiers.add(c);
    }

    public void removePreBuiltClassifier(Classifier c) {
        this.m_preBuiltClassifiers.remove(c);
    }

    @Override
    public double classifyInstance(Instance instance) throws Exception {
        double result;
        switch (this.m_CombinationRule) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                double[] dist = this.distributionForInstance(instance);
                if (instance.classAttribute().isNominal()) {
                    int index = Utils.maxIndex(dist);
                    if (dist[index] == 0.0) {
                        result = Utils.missingValue();
                        break;
                    }
                    result = index;
                    break;
                }
                if (instance.classAttribute().isNumeric()) {
                    result = dist[0];
                    break;
                }
                result = Utils.missingValue();
                break;
            }
            case 6: {
                result = this.classifyInstanceMedian(instance);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown combination rule '" + this.m_CombinationRule + "'!");
            }
        }
        return result;
    }

    protected double classifyInstanceMedian(Instance instance) throws Exception {
        double pred;
        double[] results = new double[this.m_Classifiers.length + this.m_preBuiltClassifiers.size()];
        int numResults = 0;
        int i = 0;
        while (i < this.m_Classifiers.length) {
            pred = this.m_Classifiers[i].classifyInstance(instance);
            if (!Utils.isMissingValue(pred)) {
                results[numResults++] = pred;
            }
            ++i;
        }
        i = 0;
        while (i < this.m_preBuiltClassifiers.size()) {
            pred = this.m_preBuiltClassifiers.get(i).classifyInstance(instance);
            if (!Utils.isMissingValue(pred)) {
                results[numResults++] = pred;
            }
            ++i;
        }
        if (numResults == 0) {
            return Utils.missingValue();
        }
        if (numResults == 1) {
            return results[0];
        }
        double[] actualResults = new double[numResults];
        System.arraycopy(results, 0, actualResults, 0, numResults);
        return Utils.kthSmallestValue(actualResults, actualResults.length / 2);
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] result = new double[instance.numClasses()];
        switch (this.m_CombinationRule) {
            case 1: {
                result = this.distributionForInstanceAverage(instance);
                break;
            }
            case 2: {
                result = this.distributionForInstanceProduct(instance);
                break;
            }
            case 3: {
                result = this.distributionForInstanceMajorityVoting(instance);
                break;
            }
            case 4: {
                result = this.distributionForInstanceMin(instance);
                break;
            }
            case 5: {
                result = this.distributionForInstanceMax(instance);
                break;
            }
            case 6: {
                result[0] = this.classifyInstance(instance);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown combination rule '" + this.m_CombinationRule + "'!");
            }
        }
        if (!instance.classAttribute().isNumeric() && Utils.sum(result) > 0.0) {
            Utils.normalize(result);
        }
        return result;
    }

    protected double[] distributionForInstanceAverage(Instance instance) throws Exception {
        int j;
        double[] dist;
        double[] probs = new double[instance.numClasses()];
        double numPredictions = 0.0;
        int i = 0;
        while (i < this.m_Classifiers.length) {
            dist = this.getClassifier(i).distributionForInstance(instance);
            if (!instance.classAttribute().isNumeric() || !Utils.isMissingValue(dist[0])) {
                j = 0;
                while (j < dist.length) {
                    int n = j;
                    probs[n] = probs[n] + dist[j];
                    ++j;
                }
                numPredictions += 1.0;
            }
            ++i;
        }
        i = 0;
        while (i < this.m_preBuiltClassifiers.size()) {
            dist = this.m_preBuiltClassifiers.get(i).distributionForInstance(instance);
            if (!instance.classAttribute().isNumeric() || !Utils.isMissingValue(dist[0])) {
                j = 0;
                while (j < dist.length) {
                    int n = j;
                    probs[n] = probs[n] + dist[j];
                    ++j;
                }
                numPredictions += 1.0;
            }
            ++i;
        }
        if (instance.classAttribute().isNumeric()) {
            if (numPredictions == 0.0) {
                probs[0] = Utils.missingValue();
            } else {
                int j2 = 0;
                while (j2 < probs.length) {
                    int n = j2++;
                    probs[n] = probs[n] / numPredictions;
                }
            }
        } else if (Utils.sum(probs) > 0.0) {
            Utils.normalize(probs);
        }
        return probs;
    }

    protected double[] distributionForInstanceProduct(Instance instance) throws Exception {
        int j;
        double[] dist;
        double[] probs = new double[instance.numClasses()];
        int i = 0;
        while (i < probs.length) {
            probs[i] = 1.0;
            ++i;
        }
        int numPredictions = 0;
        int i2 = 0;
        while (i2 < this.m_Classifiers.length) {
            dist = this.getClassifier(i2).distributionForInstance(instance);
            if (Utils.sum(dist) > 0.0) {
                j = 0;
                while (j < dist.length) {
                    int n = j;
                    probs[n] = probs[n] * dist[j];
                    ++j;
                }
                ++numPredictions;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.m_preBuiltClassifiers.size()) {
            dist = this.m_preBuiltClassifiers.get(i2).distributionForInstance(instance);
            if (Utils.sum(dist) > 0.0) {
                j = 0;
                while (j < dist.length) {
                    int n = j;
                    probs[n] = probs[n] * dist[j];
                    ++j;
                }
                ++numPredictions;
            }
            ++i2;
        }
        if (numPredictions == 0) {
            return new double[instance.numClasses()];
        }
        if (Utils.sum(probs) > 0.0) {
            Utils.normalize(probs);
        }
        return probs;
    }

    protected double[] distributionForInstanceMajorityVoting(Instance instance) throws Exception {
        int j;
        int maxIndex;
        double[] probs = new double[instance.classAttribute().numValues()];
        double[] votes = new double[probs.length];
        int i = 0;
        while (i < this.m_Classifiers.length) {
            probs = this.getClassifier(i).distributionForInstance(instance);
            maxIndex = 0;
            j = 0;
            while (j < probs.length) {
                if (probs[j] > probs[maxIndex]) {
                    maxIndex = j;
                }
                ++j;
            }
            if (probs[maxIndex] > 0.0) {
                j = 0;
                while (j < probs.length) {
                    if (probs[j] == probs[maxIndex]) {
                        int n = j;
                        votes[n] = votes[n] + 1.0;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.m_preBuiltClassifiers.size()) {
            probs = this.m_preBuiltClassifiers.get(i).distributionForInstance(instance);
            maxIndex = 0;
            j = 0;
            while (j < probs.length) {
                if (probs[j] > probs[maxIndex]) {
                    maxIndex = j;
                }
                ++j;
            }
            if (probs[maxIndex] > 0.0) {
                j = 0;
                while (j < probs.length) {
                    if (probs[j] == probs[maxIndex]) {
                        int n = j;
                        votes[n] = votes[n] + 1.0;
                    }
                    ++j;
                }
            }
            ++i;
        }
        int tmpMajorityIndex = 0;
        int k = 1;
        while (k < votes.length) {
            if (votes[k] > votes[tmpMajorityIndex]) {
                tmpMajorityIndex = k;
            }
            ++k;
        }
        if (votes[tmpMajorityIndex] == 0.0) {
            return new double[instance.numClasses()];
        }
        Vector<Integer> majorityIndexes = new Vector<Integer>();
        int k2 = 0;
        while (k2 < votes.length) {
            if (votes[k2] == votes[tmpMajorityIndex]) {
                majorityIndexes.add(k2);
            }
            ++k2;
        }
        int majorityIndex = (Integer)majorityIndexes.get(this.m_Random.nextInt(majorityIndexes.size()));
        probs = new double[probs.length];
        probs[majorityIndex] = 1.0;
        return probs;
    }

    protected double[] distributionForInstanceMax(Instance instance) throws Exception {
        int j;
        double[] dist;
        double[] probs = new double[instance.numClasses()];
        double numPredictions = 0.0;
        int i = 0;
        while (i < this.m_Classifiers.length) {
            dist = this.getClassifier(i).distributionForInstance(instance);
            if (!instance.classAttribute().isNumeric() || !Utils.isMissingValue(dist[0])) {
                j = 0;
                while (j < dist.length) {
                    if (probs[j] < dist[j] || numPredictions == 0.0) {
                        probs[j] = dist[j];
                    }
                    ++j;
                }
                numPredictions += 1.0;
            }
            ++i;
        }
        i = 0;
        while (i < this.m_preBuiltClassifiers.size()) {
            dist = this.m_preBuiltClassifiers.get(i).distributionForInstance(instance);
            if (!instance.classAttribute().isNumeric() || !Utils.isMissingValue(dist[0])) {
                j = 0;
                while (j < dist.length) {
                    if (probs[j] < dist[j] || numPredictions == 0.0) {
                        probs[j] = dist[j];
                    }
                    ++j;
                }
                numPredictions += 1.0;
            }
            ++i;
        }
        if (instance.classAttribute().isNumeric()) {
            if (numPredictions == 0.0) {
                probs[0] = Utils.missingValue();
            }
        } else if (Utils.sum(probs) > 0.0) {
            Utils.normalize(probs);
        }
        return probs;
    }

    protected double[] distributionForInstanceMin(Instance instance) throws Exception {
        int j;
        double[] dist;
        double[] probs = new double[instance.numClasses()];
        double numPredictions = 0.0;
        int i = 0;
        while (i < this.m_Classifiers.length) {
            dist = this.getClassifier(i).distributionForInstance(instance);
            if (!instance.classAttribute().isNumeric() || !Utils.isMissingValue(dist[0])) {
                j = 0;
                while (j < dist.length) {
                    if (probs[j] > dist[j] || numPredictions == 0.0) {
                        probs[j] = dist[j];
                    }
                    ++j;
                }
                numPredictions += 1.0;
            }
            ++i;
        }
        i = 0;
        while (i < this.m_preBuiltClassifiers.size()) {
            dist = this.m_preBuiltClassifiers.get(i).distributionForInstance(instance);
            if (!instance.classAttribute().isNumeric() || !Utils.isMissingValue(dist[0])) {
                j = 0;
                while (j < dist.length) {
                    if (probs[j] > dist[j] || numPredictions == 0.0) {
                        probs[j] = dist[j];
                    }
                    ++j;
                }
                numPredictions += 1.0;
            }
            ++i;
        }
        if (instance.classAttribute().isNumeric()) {
            if (numPredictions == 0.0) {
                probs[0] = Utils.missingValue();
            }
        } else if (Utils.sum(probs) > 0.0) {
            Utils.normalize(probs);
        }
        return probs;
    }

    public String combinationRuleTipText() {
        return "The combination rule used.";
    }

    public SelectedTag getCombinationRule() {
        return new SelectedTag(this.m_CombinationRule, TAGS_RULES);
    }

    public void setCombinationRule(SelectedTag newRule) {
        if (newRule.getTags() == TAGS_RULES) {
            this.m_CombinationRule = newRule.getSelectedTag().getID();
        }
    }

    public String preBuiltClassifiersTipText() {
        return "The pre-built serialized classifiers to include. Multiple serialized classifiers can be included alongside those that are built from scratch when this classifier runs. Note that it does not make sense to include pre-built classifiers in a cross-validation since they are static and their models do not change from fold to fold.";
    }

    public void setPreBuiltClassifiers(File[] preBuilt) {
        this.m_classifiersToLoad.clear();
        if (preBuilt != null && preBuilt.length > 0) {
            int i = 0;
            while (i < preBuilt.length) {
                String path = preBuilt[i].toString();
                this.m_classifiersToLoad.add(path);
                ++i;
            }
        }
    }

    public File[] getPreBuiltClassifiers() {
        File[] result = new File[this.m_classifiersToLoad.size()];
        int i = 0;
        while (i < this.m_classifiersToLoad.size()) {
            result[i] = new File(this.m_classifiersToLoad.get(i));
            ++i;
        }
        return result;
    }

    public String toString() {
        if (this.m_Classifiers == null) {
            return "Vote: No model built yet.";
        }
        String result = "Vote combines";
        result = String.valueOf(result) + " the probability distributions of these base learners:\n";
        int i = 0;
        while (i < this.m_Classifiers.length) {
            result = String.valueOf(result) + '\t' + this.getClassifierSpec(i) + '\n';
            ++i;
        }
        for (Classifier c : this.m_preBuiltClassifiers) {
            result = String.valueOf(result) + "\t" + c.getClass().getName() + Utils.joinOptions(((OptionHandler)((Object)c)).getOptions()) + "\n";
        }
        result = String.valueOf(result) + "using the '";
        switch (this.m_CombinationRule) {
            case 1: {
                result = String.valueOf(result) + "Average";
                break;
            }
            case 2: {
                result = String.valueOf(result) + "Product";
                break;
            }
            case 3: {
                result = String.valueOf(result) + "Majority Voting";
                break;
            }
            case 4: {
                result = String.valueOf(result) + "Minimum";
                break;
            }
            case 5: {
                result = String.valueOf(result) + "Maximum";
                break;
            }
            case 6: {
                result = String.valueOf(result) + "Median";
                break;
            }
            default: {
                throw new IllegalStateException("Unknown combination rule '" + this.m_CombinationRule + "'!");
            }
        }
        result = String.valueOf(result) + "' combination rule \n";
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10487 $");
    }

    @Override
    public void setEnvironment(Environment env) {
        this.m_env = env;
    }

    @Override
    public Classifier aggregate(Classifier toAggregate) throws Exception {
        if (this.m_structure == null && this.m_Classifiers.length == 1 && this.m_Classifiers[0] instanceof ZeroR) {
            this.setClassifiers(new Classifier[0]);
        }
        this.addPreBuiltClassifier(toAggregate);
        return this;
    }

    @Override
    public void finalizeAggregation() throws Exception {
    }

    public static void main(String[] argv) {
        Vote.runClassifier(new Vote(), argv);
    }
}

